window.ee = (function() {

    /* The checkout step indexes need to match what's defined in Analytics! */
    /* Do not change them unless you know what you're doing. */
    var checkoutSteps = {
        prescription_created: 1, // Prescription created
        item_added: 2, // Item added
        landed_on_basic_details_page: 3, // Landed on Basic Details page
        landed_on_find_gp_page: 4, // Landed on Find GP page
        landed_on_additional_details_page: 5, // Landed on Additional Details page
        landed_on_confirm_page: 6, // Landed on Confirm page
    }

    window.dataLayer = window.dataLayer || [];


    function triggerProductViewEvent() {
        console.debug('[triggerProductViewEvent]');

        window.dataLayer.push({ ecommerce: null });
        window.dataLayer.push({
            'event': 'productView',
            'ecommerce': {
                'detail': {
                    'products': [{
                        'name': 'NHS Prescription',
                        'id': '123',
                    }]
                }
            }
        });
    }


    function triggerAddToCartEvent() {
        console.debug('[triggerAddToCart]');

        window.dataLayer.push({ ecommerce: null });
        window.dataLayer.push({
            'event': 'addToCart',
            'ecommerce': {
                'currencyCode': 'GBP',
                'add': {
                    'products': [{
                        'name': 'NHS Prescription',
                        'id': '123',
                    }]
                }
            }
        });
    }


    function triggerCheckoutEvent(params) {
        console.debug('[triggerCheckoutEvent]');

        stepNumber = checkoutSteps[params.stepName] || 1;

        console.debug(params);
        var actionFieldObject = { step: stepNumber };
        if (params.option) { actionFieldObject.option =  params.option; }
        console.debug(actionFieldObject);

        window.dataLayer.push({ ecommerce: null });
        window.dataLayer.push({
            'event': 'checkout',
            'ecommerce': {
                'checkout': {
                    'actionField': actionFieldObject,
                    'products': [{
                        'name': 'NHS Prescription',
                        'id': '123',
                    }]
                }
            },
            'eventCallback': function() {
                //document.location = 'checkout.html';
            }
        });
    }


    function triggerPurchaseEvent(params) {
        console.debug('[triggerPurchaseEvent]');

        window.dataLayer.push({ ecommerce: null });
        for (var i = 0; i < params.orderIDs.length; i++) {
            var orderID = params.orderIDs[i];
            console.debug("Order ID: " + orderID);
            window.dataLayer.push({
                'event': 'purchaseConfirmed',
                'ecommerce': {
                    'purchase': {
                        'actionField': {
                            'id': orderID,
                            'revenue': '1',
                        },
                        'products': [{
                            'name': 'NHS Prescription',
                            'id': '123',
                        }]
                    }
                }
            });
        }
    }


    var publicMethods = {

        sendEvent: function(eventName, params) {

            console.debug('[' + eventName + ']');

            switch (eventName) {

                case "productView":
                    triggerProductViewEvent();
                    break;

                case "addToCart":
                    triggerAddToCartEvent();
                    break;

                case "checkout":
                    triggerCheckoutEvent(params);
                    break;

                case "purchase":
                    triggerPurchaseEvent(params);
                    break;

            }

        },

    }

    return publicMethods;


})();


/* Markup Rriggers */

window.eeTrackingData = window.eeTrackingData || {};

if (eeTrackingData.event) {
    ee.sendEvent(eeTrackingData.event);
}


/*

OVERVIEW of EVENTS:
==================

[productView]: landed on /nhs-prescriptions

[addToCart]: landed on /nhs-prescriptions/welcome

[checkout]:

- Step Add Prescription ("Add Prescription" button clicked)

- Step Add Product ("Add Item" button clicked)

- Step Basic Details ("Get to know you" button clicked)

- Step Find GP ("Find a GP" button clicked)

- Step Additional Details ("More about you" button clicked)

- Confirm ("Confirm and submit" button clicked)

[purchase]: this will be different for paying and non-paying customers

*/
