<?php
/**
 * Image folders
 *
 * Site specific image folder sizes go here and are included
 * within $image_folders['cms_images'] to allow CMS admin access
 * to these sizes
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

$image_folders['slideshow_images'] = [
    "slide_square" => [
        'path' => 'uploads/images/slideshow_square',
        'width' => 1196,
        'height' => 1000,
        'forced' => true,
        'crop' => true
    ],
    "slide_square_mobile" => [
        'path' => 'uploads/images/slideshow_square_mobile',
        'width' => 640,
        'height' => 643,
        'forced' => true,
        'crop' => true
    ],
    "slide_rectangle" => [
        'path' => 'uploads/images/slide_rectangle',
        'width' => 656,
        'height' => 474,
        'forced' => true,
        'crop' => true
    ],
    "slide" => [
        'path' => 'uploads/images/slideshow',
        'width' => 2000,
        'height' => 600,
        'forced' => true,
        'crop' => true
    ],
    "slide_mobile" => [
        'path' => 'uploads/images/slide_mobile',
        'width' => 767,
        'height' => 767,
        'forced' => true,
        'crop' => true
    ],
    "slide_boxed" => [
        'path' => 'uploads/images/slide_boxed',
        'width' => 1310,
        'height' => 526,
        'forced' => true,
        'crop' => true
    ],
    "slide_boxed_tablet" => [
        'path' => 'uploads/images/slide_boxed_tablet',
        'width' => 932,
        'height' => 374,
        'forced' => true,
        'crop' => true
    ],
    "slide_boxed_tablet_small" => [
        'path' => 'uploads/images/slide_boxed_tablet_small',
        'width' => 752,
        'height' => 460,
        'forced' => true,
        'crop' => true
    ],
    "slide_boxed_mobile" => [
        'path' => 'uploads/images/slide_boxed_mobile',
        'width' => 595,
        'height' => 355,
        'forced' => true,
        'crop' => true
    ],
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['slideshow_images']);
}
//{"image_sizes":["image_banner_about"]}
/*
 * Offer block images
 */

$image_folders['offer_block'] = [
    "offer_block_card" => [
        'path' => 'uploads/images/offer_block_card',
        'width' => 602,
        'height' => 602,
        'forced' => true,
        'crop' => true
    ]
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['offer_block']);
}
//{"crop_adjust":["offer_block_card"], "image_sizes":["offer_block_card"]}

/*
 * Image size used for text and image call out partial
 */

$image_folders['selling_points'] = [
    "selling_point_icon" => [
        'path' => 'uploads/images/selling_point_icon',
        'width' => 94,
        'height' => 94,
        'forced' => true,
        'crop' => true
    ]
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['selling_points']);
}

//{"crop_adjust":["selling_point_icon"], "image_sizes":["selling_point_icon"]}

/*
 * Image size used for Services list partial
 */

$image_folders['services_list'] = [
    "services_list" => [
        'path' => 'uploads/images/services_list',
        'width' => 767,
        'height' => 575,
        'forced' => false,
        'crop' => true
    ],
    "services_icons" => [
        'path' => 'uploads/images/services_icons',
        'width' => 500,
        'forced' => true,
        'crop' => false
    ],
    "services_icons_small" => [
        'path' => 'uploads/images/services_icons_small',
        'width' => 268,
        'height' => 160,
        'forced' => false,
        'crop' => true
    ]
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['services_list']);
}

/*
 * Testimonial slider images
 */

$image_folders['testimonial_slider'] = [
    "testimonial_slider" => [
        'path' => 'uploads/images/testimonial_slider',
        'width' => 95,
        'height' => 95,
        'forced' => false,
        'crop' => true
    ]
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['testimonial_slider']);
}


/*
 * Testimonial slider images
 */

$image_folders['testimonial_boxes'] = [
    "testimonial_box" => [
        'path' => 'uploads/images/testimonial_box',
        'width' => 238,
        'height' => 273,
        'forced' => false,
        'crop' => true
    ]
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['testimonial_boxes']);
}


/*
 * News listing and article images
 */

$image_folders['news_images'] = [
    "news_large" => [
        "path" => "uploads/images/cms/news_large",
        "width" => 750,
        "height" => 900,
        "crop" => 1
    ],
    "news_image" => [
        "path" => "uploads/images/cms/news_image",
        "width" => 750,
        "height" => 900,
        "crop" => 1
    ],

    "blog_listing_image" => [
        "path" => "uploads/images/cms/blog_listing_image",
        "width" => 870,
        "height" => 490,
        "crop" => 1
    ],

    "blog_listing_image_mobile" => [
        "path" => "uploads/images/cms/blog_listing_image_mobile",
        "width" => 600,
        "height" => 279,
        "crop" => 1
    ]
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['news_images']);
}

//{"crop_adjust":["news_large", "news_image", "blog_listing_image", "blog_listing_image_mobile"], "image_sizes":["news_large", "news_image", "blog_listing_image", "blog_listing_image_mobile"]}






/*
 * New Image Sizes
 */



/*
 * Hero Banner
 */

$image_folders["title_banner"] = [
    "title_banner" => [
        "path" => "uploads/images/cms/title_banner",
        "width" => 2000,
        "height" => 533,
        "forced" => true,
        "crop" => 1
    ],
    "title_banner_mobile" => [
        "path" => "uploads/images/cms/title_banner_mobile",
        "width" => 640,
        "height" => 400,
        "forced" => true,
        "crop" => 1
    ],
    "title_banner_large" => [
        "path" => "uploads/images/cms/title_banner_large",
        "width" => 2000,
        "height" => 666,
        "forced" => true,
        "crop" => 1
    ],
    "title_banner_large_mobile" => [
        "path" => "uploads/images/cms/title_banner_large_mobile",
        "width" => 640,
        "height" => 420,
        "forced" => true,
        "crop" => 1
    ],
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['title_banner']);
}
//{"crop_adjust":["title_banner_large", "title_banner"], "image_sizes":["title_banner_large", "title_banner_large_mobile", "title_banner", "title_banner_mobile"]}
//{"crop_adjust":["title_banner_large_mobile", "title_banner_mobile"], "image_sizes":["title_banner_large", "title_banner_large_mobile", "title_banner", "title_banner_mobile"]}
/*
 * Image banner
*/

$image_folders["image_banner"] = [
    "image_banner_desktop" => [
        "path" => "uploads/images/cms/image_banner_desktop/",
        "width" => 1440,
        "height" => 980,
        "forced" => true,
        "crop" => 1
    ],
    "image_banner_desktop_small" => [
        "path" => "uploads/images/cms/image_banner_desktop_small/",
        "width" => 720,
        "height" => 490,
        "forced" => true,
        "crop" => 1
    ],
    "image_banner_mobile" => [
        "path" => "uploads/images/cms/image_banner_mobile/",
        "width" => 640,
        "height" => 640,
        "forced" => true,
        "crop" => 1
    ],
    "image_banner_mobile_small" => [
        "path" => "uploads/images/cms/image_banner_mobile_small/",
        "width" => 640,
        "height" => 640,
        "forced" => true,
        "crop" => 1
    ],
    "image_banner_about" => [
        "path" => "uploads/images/cms/image_banner_about/",
        "width" => 1371,
        "height" => 796,
        "forced" => true,
        "crop" => 1
    ],
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['image_banner']);
}


/*
 * Hero Banner
 */
//{"crop_adjust":["video_banner","hero_banner_mobile"], "image_sizes":["video_banner","hero_banner_mobile"]}
$image_folders["video_banner"] = [
    "video_banner" => [
        "path" => "uploads/images/cms/video_banner",
        "width" => 920,
        "height" => 518,
        "forced" => true,
        "crop" => 1
    ],
    "video_banner_mobile" => [
        "path" => "uploads/images/cms/video_banner_mobile",
        "width" => 640,
        "height" => 360,
        "forced" => true,
        "crop" => 1
    ]
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['video_banner']);
}


/*
 * CTA Boxes
 */

$image_folders["cta_boxes"] = [
    "cta_box" => [
        "path" => "uploads/images/cms/cta_box",
        "width" => 684,
        "height" => 480,
        "forced" => true,
        "crop" => 1
    ],
    "cta_box_wide" => [
        "path" => "uploads/images/cms/cta_box_wide",
        "width" => 852,
        "height" => 480,
        "forced" => true,
        "crop" => 1
    ],
    "cta_box_mobile" => [
        "path" => "uploads/images/cms/cta_box_mobile",
        "width" => 608,
        "height" => 498,
        "forced" => true,
        "crop" => 1
    ],
    "cta_box_mobile_tall" => [
        "path" => "uploads/images/cms/cta_box_mobile_tall",
        "width" => 358,
        "height" => 358,
        "forced" => true,
        "crop" => 1
    ],
];
//Recommended size: 1000px x 702px
//{"crop_adjust":["cta_box","cta_box_wide","cta_box_mobile","cta_box_mobile_tall"], "image_sizes":["cta_box","cta_box_wide","cta_box_mobile","cta_box_mobile_tall"]}

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['cta_boxes']);
}

/*
 * Online Doctor Categories
 */
$image_folders['online_doctor_images'] = [
    "online_doctor_thumb" => [
        "path" => "uploads/images/cms/online_doctor_thumb",
        "width" => 316,
        "height" => 316,
        "crop" => 1,
        "forced" => true,
    ],
    "online_doctor_square" => [
        "path" => "uploads/images/cms/online_doctor_square",
        "width" => 696,
        "height" => 696,
        "crop" => 1,
        "forced" => true,
    ],
    "online_doctor_long" => [
        "path" => "uploads/images/cms/online_doctor_long",
        "width" => 696,
        "height" => 316,
        "crop" => 1,
        "forced" => true,
    ],
    "online_doctor_tall" => [
        "path" => "uploads/images/cms/online_doctor_tall",
        "width" => 316,
        "height" => 696,
        "crop" => 1,
        "forced" => true,
    ],
    "online_doctor_mobile" => [
        "path" => "uploads/images/cms/online_doctor_mobile",
        "width" => 576,
        "height" => 576,
        "crop" => 1,
        "forced" => true,
    ],
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['online_doctor_images']);
}



$image_folders["team"] = [
    "team_desktop" => [
        'path' => 'uploads/images/team_desktop',
        'width' => 272,
        'height' => 312,
        'forced' => false,
        'crop' => true
    ]
];
//{"crop_adjust":["team_desktop"], "image_sizes":["team_desktop"]}
if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['team']);
}


$image_folders["general_content"] = [
    "content_image" => [
        'path' => 'uploads/images/content_image',
        'width' => 1120,
        'forced' => true,
        'crop' => false
    ],
    "content_image_mobile" => [
        'path' => 'uploads/images/content_image_mobile',
        'width' => 640,
        'forced' => true,
        'crop' => false
    ]
];
//{"crop_adjust":["content_image","content_image_mobile"], "image_sizes":["content_image","content_image_mobile"]}
if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['general_content']);
}



$image_folders["grid_cards"] = [
    "grid_cards" => [
        'path' => 'uploads/images/grid_cards',
        'width' => 448,
        'height' => 208,
        'forced' => true,
        'crop' => true
    ],
    "grid_cards_medium" => [
        'path' => 'uploads/images/grid_cards_medium',
        'width' => 454,
        'height' => 208,
        'forced' => true,
        'crop' => true
    ],
    "grid_cards_small" => [
        'path' => 'uploads/images/grid_cards_small',
        'width' => 468,
        'height' => 206,
        'forced' => true,
        'crop' => true
    ]
];
//{"crop_adjust":["grid_cards","grid_cards_medium","grid_cards_small"], "image_sizes":["grid_cards","grid_cards_medium","grid_cards_small"]}
if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['grid_cards']);
}

/*
 * Brands
 */

$image_folders['brand_images'] = [
    "partners" => [
        "path" => "uploads/images/cms/partners",
        'width' => 336,
        'height' => 188,
        'forced' => true,
        'crop' => true
    ],
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['brand_images']);
}
//{"crop_adjust":["partners"], "image_sizes":["partners"]}



/*
* Category CTA Boxes
*/
$image_folders['category_ctas'] = [
    "category_box" => [
        "path" => "uploads/images/cms/category_box",
        "width" => 438,
        "height" => 438,
        "crop" => 1,
        "forced" => true,
    ]
];

if (!empty($image_folders['cms_images'])) {
    $image_folders['cms_images'] = array_merge($image_folders['cms_images'], $image_folders['category_ctas']);
}
//{"crop_adjust":["category_box"], "image_sizes":["category_box"]}
