<?php
use Mtc\Shop\Category;
use Mtc\Core\PaginationTemplate;


if(!empty($_REQUEST['page'])) {
    $current_page = (int) $_REQUEST['page'];
}else{
    $current_page = 1;
}

$per_page = 12;
$offset = ($current_page - 1) * $per_page;

$search_term = false;

if(!empty($_REQUEST['search_term'])) {

    $search_term = $_REQUEST['search_term'];


    //Count results
    $all_categories = \Mtc\Shop\Category::query()
                                        ->where('is_online_doctor', '=', '1')
                                        ->where('name', '!=', 'Doctor')
                                        ->where('sub_id', '!=', 0)
                                        ->where('name', 'LIKE', $search_term . '%')
                                        ->orderBy('name');

    //Get categories
    $categories = \Mtc\Shop\Category::query()
                                    ->where('is_online_doctor', '=', '1')
                                    ->where('name', '!=', 'Doctor')
                                    ->where('sub_id', '!=', 0)
                                    ->where('name', 'LIKE', $search_term . '%')
                                    ->orderBy('name')
                                    ->limit($per_page)
                                    ->offset($offset)
                                    ->get();
}else{

    //Count results
    $all_categories = \Mtc\Shop\Category::query()
                                        ->where('is_online_doctor', '=', '1')
                                        ->where('name', '!=', 'Doctor')
                                        ->where('sub_id', '!=', 0)
                                        ->orderBy('name');

    //Get categories
    $categories = \Mtc\Shop\Category::query()
                                    ->where('is_online_doctor', '=', '1')
                                    ->where('name', '!=', 'Doctor')
                                    ->where('sub_id', '!=', 0)
                                    ->orderBy('name')
                                    ->limit($per_page)
                                    ->offset($offset)
                                    ->get();

}



$categories->map(function($category){

    //Build url
    if($category->is_online_doctor == '1') {
        $category->url = '/online-doctor/' . $category->slug;
    }

    //Build items
    $item_links = [
        'visible_items' => [],
        'hidden_items' => []
    ];

    $items = $category->items()
              ->where('product_type', '!=', '')
              ->active()
              ->get()
              ->map(function( $item ) use ( &$item_links ) {

                  $item->url = (new \Item($item->id))->url;

                  if(!empty($item->name) && !empty($item->url)) {


                      $item_data = [
                          'title' => $item->name,
                          'url'   => $item->url
                      ];


                      if (count($item_links['visible_items']) < 3) {

                          $item_links['visible_items'][] = $item_data;

                      } else {
                          $item_links['hidden_items'][] = $item_data;
                      }
                  }

                  return $item;
              });


    $category->item_links = $item_links;
    return $category;

});


$twig->addGlobal('categories', $categories->toArray());



if(!empty($search_term)) {
    $query_string = '?search_term=' . $search_term;
}else{
    $query_string = '';
}

$pagination = new PaginationTemplate([
    'item_count' => $all_categories->count(),
    'per_page' => $per_page,
    'active_page' => $current_page,
    'show_view_all' => false,
    'show_next' => true,
    'show_previous' => true,
    'page_url' => '/conditions/' . $query_string,
]);
$pagination = $pagination->render($twig);

$twig->addGlobal('pagination', $pagination);

$twig->addGlobal('search_term', $search_term);



