<?php

/*
 * Content blocks with sidebar
 */
$description_tabs = [];
if (!empty($p->pagedata['Content Sections'])) {
    //Loop each content section
    foreach ($p->pagedata['Content Sections'] as $row) {

        //Build array content
        $title   = $row['Title']['value'];
        $content = $row['Content']['value'];

        //Add to tabs is content exists
        if (!empty($title) && !empty($content)) {

            $description_tabs[] = [
                'title'   => $title,
                'content' => $content
            ];

        }

    }

    //Set twig variable to use in template
    $twig->addGlobal('tabs_from_controller', $description_tabs);
}

/*
 * Carousel Examples - Test Data
 */

// Example 1: Product Carousel
$example_products = [
    [
        'name' => 'Paracetamol 500mg',
        'price' => '£3.99',
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="300" height="300"%3E%3Crect fill="%234A90E2" width="300" height="300"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="24" fill="white"%3EProduct 1%3C/text%3E%3C/svg%3E',
        'url' => '#'
    ],
    [
        'name' => 'Ibuprofen 400mg',
        'price' => '£4.99',
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="300" height="300"%3E%3Crect fill="%2350C878" width="300" height="300"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="24" fill="white"%3EProduct 2%3C/text%3E%3C/svg%3E',
        'url' => '#'
    ],
    [
        'name' => 'Vitamin C Tablets',
        'price' => '£6.99',
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="300" height="300"%3E%3Crect fill="%23FF6B6B" width="300" height="300"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="24" fill="white"%3EProduct 3%3C/text%3E%3C/svg%3E',
        'url' => '#'
    ],
    [
        'name' => 'Aspirin 75mg',
        'price' => '£2.99',
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="300" height="300"%3E%3Crect fill="%23FFD93D" width="300" height="300"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="24" fill="white"%3EProduct 4%3C/text%3E%3C/svg%3E',
        'url' => '#'
    ],
    [
        'name' => 'Multivitamins',
        'price' => '£8.99',
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="300" height="300"%3E%3Crect fill="%23A78BFA" width="300" height="300"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="24" fill="white"%3EProduct 5%3C/text%3E%3C/svg%3E',
        'url' => '#'
    ],
    [
        'name' => 'Omega 3 Fish Oil',
        'price' => '£12.99',
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="300" height="300"%3E%3Crect fill="%2360A5FA" width="300" height="300"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="24" fill="white"%3EProduct 6%3C/text%3E%3C/svg%3E',
        'url' => '#'
    ]
];
$twig->addGlobal('example_products', $example_products);

// Example 2: Trust Logos Carousel
$example_trust_logos = [
    ['image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="150" height="80"%3E%3Crect fill="%23333333" width="150" height="80"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="16" fill="white"%3ELogo 1%3C/text%3E%3C/svg%3E', 'alt' => 'Partner 1'],
    ['image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="150" height="80"%3E%3Crect fill="%23333333" width="150" height="80"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="16" fill="white"%3ELogo 2%3C/text%3E%3C/svg%3E', 'alt' => 'Partner 2'],
    ['image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="150" height="80"%3E%3Crect fill="%23333333" width="150" height="80"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="16" fill="white"%3ELogo 3%3C/text%3E%3C/svg%3E', 'alt' => 'Partner 3'],
    ['image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="150" height="80"%3E%3Crect fill="%23333333" width="150" height="80"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="16" fill="white"%3ELogo 4%3C/text%3E%3C/svg%3E', 'alt' => 'Partner 4'],
    ['image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="150" height="80"%3E%3Crect fill="%23333333" width="150" height="80"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="16" fill="white"%3ELogo 5%3C/text%3E%3C/svg%3E', 'alt' => 'Partner 5'],
    ['image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="150" height="80"%3E%3Crect fill="%23333333" width="150" height="80"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="16" fill="white"%3ELogo 6%3C/text%3E%3C/svg%3E', 'alt' => 'Partner 6'],
    ['image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="150" height="80"%3E%3Crect fill="%23333333" width="150" height="80"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="16" fill="white"%3ELogo 7%3C/text%3E%3C/svg%3E', 'alt' => 'Partner 7'],
    ['image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="150" height="80"%3E%3Crect fill="%23333333" width="150" height="80"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="16" fill="white"%3ELogo 8%3C/text%3E%3C/svg%3E', 'alt' => 'Partner 8']
];
$twig->addGlobal('example_trust_logos', $example_trust_logos);

// Example 3: Selling Points
$example_selling_points = [
    ['icon' => 'fa-truck', 'title' => 'Fast Delivery', 'description' => '24-hour dispatch on all orders'],
    ['icon' => 'fa-shield-alt', 'title' => 'Secure Payment', 'description' => 'SSL encrypted transactions'],
    ['icon' => 'fa-phone', 'title' => '24/7 Support', 'description' => 'Always here to help you'],
    ['icon' => 'fa-certificate', 'title' => 'Registered Pharmacy', 'description' => 'Fully qualified pharmacists']
];
$twig->addGlobal('example_selling_points', $example_selling_points);

/*
 * Slideshow Examples - Test Data
 */

// Example 1: Hero Slideshow
$example_hero_slides = [
    [
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="1920" height="600"%3E%3Crect fill="%234A90E2" width="1920" height="600"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="48" fill="white"%3EWelcome%3C/text%3E%3C/svg%3E',
        'title' => 'Welcome to Our Online Pharmacy',
        'description' => 'Your health is our priority. Browse our range of prescription and over-the-counter medications.',
        'link' => '/shop',
        'link_text' => 'Shop Now'
    ],
    [
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="1920" height="600"%3E%3Crect fill="%2350C878" width="1920" height="600"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="48" fill="white"%3EFast Delivery%3C/text%3E%3C/svg%3E',
        'title' => 'Fast & Free Delivery',
        'description' => 'Get your medications delivered to your door with our express delivery service.',
        'link' => '/delivery',
        'link_text' => 'Learn More'
    ],
    [
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="1920" height="600"%3E%3Crect fill="%23FF6B6B" width="1920" height="600"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="48" fill="white"%3EExpert Advice%3C/text%3E%3C/svg%3E',
        'title' => 'Expert Healthcare Advice',
        'description' => 'Speak to our qualified pharmacists for professional healthcare guidance.',
        'link' => '/contact',
        'link_text' => 'Contact Us'
    ]
];
$twig->addGlobal('example_hero_slides', $example_hero_slides);

// Example 2: Simple Image Slideshow (no text)
$example_promo_slides = [
    [
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="1200" height="400"%3E%3Crect fill="%23FFD93D" width="1200" height="400"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="36" fill="%23333333"%3EPromotion 1%3C/text%3E%3C/svg%3E',
        'title' => 'Summer Sale',
        'description' => 'Save up to 30% on selected items'
    ],
    [
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="1200" height="400"%3E%3Crect fill="%23A78BFA" width="1200" height="400"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="36" fill="%23333333"%3EPromotion 2%3C/text%3E%3C/svg%3E',
        'title' => 'New Arrivals',
        'description' => 'Check out our latest products'
    ],
    [
        'image' => 'data:image/svg+xml,%3Csvg xmlns="http://www.w3.org/2000/svg" width="1200" height="400"%3E%3Crect fill="%2360A5FA" width="1200" height="400"/%3E%3Ctext x="50%25" y="50%25" dominant-baseline="middle" text-anchor="middle" font-family="sans-serif" font-size="36" fill="%23333333"%3EPromotion 3%3C/text%3E%3C/svg%3E',
        'title' => 'Health Tips',
        'description' => 'Read our latest health articles'
    ]
];
$twig->addGlobal('example_promo_slides', $example_promo_slides);

