# Tasks: Component Registry

**Input**: Design documents from `/home/kieran/projects/pharmacy-starter/specs/001-component-registry/`
**Prerequisites**: plan.md (required), research.md, data-model.md, contracts/

## Format: `[ID] [P?] Description`
- **[P]**: Can run in parallel (different files, no dependencies)
- Include exact file paths in descriptions

## Path Conventions
Based on plan.md: Web application using existing pharmacy system structure
- **Frontend**: `sites/default/js/components/`
- **Backend**: Laravel controllers, services, routes
- **Templates**: `sites/default/templates/`
- **Tests**: `tests/`

## Phase 3.1: Setup
- [X] T001 Create component registry service directory structure in Laravel
- [X] T002 [P] Add component registry route definitions to routes/web.php
- [X] T003 [P] Set up component caching configuration in config/cache.php

## Phase 3.2: Tests First (TDD) ⚠️ MUST COMPLETE BEFORE 3.3
**CRITICAL: These tests MUST be written and MUST FAIL before ANY implementation**
- [X] T004 [P] Contract test GET /api/components in tests/Feature/ComponentRegistryApiTest.php
- [X] T005 [P] Contract test GET /api/components/{path} in tests/Feature/ComponentDetailApiTest.php
- [X] T006 [P] Contract test GET /components/{path}/preview in tests/Feature/ComponentPreviewTest.php
- [X] T007 [P] Integration test component discovery workflow in tests/Feature/ComponentDiscoveryTest.php
- [X] T008 [P] Integration test component rendering with error handling in tests/Feature/ComponentRenderingTest.php
- [X] T009 [P] Integration test Vue.js component loading in tests/Feature/ComponentRegistryPageTest.php

## Phase 3.3: Core Implementation (ONLY after tests are failing)
- [X] T010 [P] Component entity model in app/Models/Component.php (data structure for discovered components)
- [X] T011 [P] ComponentSampleData model in app/Models/ComponentSampleData.php
- [X] T012 ComponentScanner service in app/Services/ComponentScannerService.php (file system scanning logic)
- [X] T013 ComponentRenderer service in app/Services/ComponentRendererService.php (Twig rendering with sample data)
- [X] T014 ComponentRegistry controller in app/Http/Controllers/ComponentRegistryController.php
- [X] T015 ComponentPreview controller in app/Http/Controllers/ComponentPreviewController.php
- [X] T016 Vue.js ComponentRegistry component in sites/default/js/components/component_registry.vue
- [X] T017 Isolated layout template in sites/default/templates/layouts/component_preview.twig
- [X] T018 Component preview page template in sites/default/templates/component_preview.twig

## Phase 3.4: Integration
- [X] T019 Register Vue.js ComponentRegistry component in sites/default/js/app.js
- [X] T020 Add API routes for component data endpoints in routes/api.php
- [X] T021 Add web routes for component preview pages in routes/web.php
- [X] T022 Configure Twig environment for component rendering in ComponentRendererService
- [X] T023 Implement caching layer for component discovery in ComponentScannerService
- [X] T024 Add error handling middleware for component preview routes

## Phase 3.5: Polish
- [X] T025 [P] Unit tests for ComponentScannerService in tests/Unit/ComponentScannerServiceTest.php
- [X] T026 [P] Unit tests for ComponentRendererService in tests/Unit/ComponentRendererServiceTest.php
- [X] T027 [P] Performance validation: component registry page loads under 5 seconds
- [X] T028 [P] Update component discovery documentation in COMPONENT_REGISTRY.md
- [X] T029 Manual testing using quickstart.md validation scenarios
- [X] T030 Remove any temporary/debug code and ensure code quality

## Dependencies
- Setup tasks (T001-T003) before tests (T004-T009)
- Tests (T004-T009) before implementation (T010-T024)
- T010-T011 (models) before T012-T013 (services)
- T012-T013 (services) before T014-T015 (controllers)
- T016 (Vue component) after T014 (API controller)
- T017-T018 (templates) after T015 (preview controller)
- T019-T024 (integration) after core implementation
- Implementation before polish (T025-T030)

## Parallel Example
```
# Launch T004-T009 together (all different test files):
Task: "Contract test GET /api/components in tests/Feature/ComponentRegistryApiTest.php"
Task: "Contract test GET /api/components/{path} in tests/Feature/ComponentDetailApiTest.php"
Task: "Contract test GET /components/{path}/preview in tests/Feature/ComponentPreviewTest.php"
Task: "Integration test component discovery workflow in tests/Feature/ComponentDiscoveryTest.php"
Task: "Integration test component rendering with error handling in tests/Feature/ComponentRenderingTest.php"
Task: "Integration test Vue.js component loading in tests/Feature/ComponentRegistryPageTest.php"
```

```
# Launch T010-T011 together (different model files):
Task: "Component entity model in app/Models/Component.php"
Task: "ComponentSampleData model in app/Models/ComponentSampleData.php"
```

## Notes
- [P] tasks = different files, no dependencies
- Verify tests fail before implementing
- Commit after each task
- Component registry uses existing Vite build system (no changes to vite.config.js)
- Preserve single JS/CSS file compilation as specified

## Task Generation Rules Applied
1. **From Contracts**: Each API endpoint → contract test task [P] + implementation task
2. **From Data Model**: Component & ComponentSampleData entities → model creation tasks [P]
3. **From Plan**: Vue.js component, Twig templates, Laravel services → implementation tasks
4. **From Quickstart**: Integration test scenarios → integration test tasks [P]

## Validation Checklist
- [x] All contracts have corresponding tests (T004-T006)
- [x] All entities have model tasks (T010-T011)
- [x] All tests come before implementation
- [x] Parallel tasks truly independent (different files)
- [x] Each task specifies exact file path
- [x] No task modifies same file as another [P] task
- [x] Vue.js integration with existing Vite build system preserved
- [x] Component registry integrates with existing frontend structure