<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class ComponentDetailApiTest extends TestCase
{
    /**
     * Test GET /api/components/{path} returns component details
     */
    public function test_get_component_detail_api_returns_component_info()
    {
        $componentPath = 'pages/newsletter/newsletter_form.twig';
        $response = $this->get('/api/components/' . $componentPath);

        $response->assertStatus(200)
                 ->assertJsonStructure([
                     'component' => [
                         'name',
                         'filename',
                         'path',
                         'category',
                         'description',
                         'is_renderable',
                         'file_size',
                         'modified_at'
                     ],
                     'sample_data',
                     'usage' => [
                         'include_example',
                         'required_variables',
                         'optional_variables'
                     ]
                 ]);
    }

    /**
     * Test GET /api/components/{path} returns 404 for non-existent component
     */
    public function test_get_component_detail_api_returns_404_for_missing_component()
    {
        $response = $this->get('/api/components/non/existent/component.twig');

        $response->assertStatus(404)
                 ->assertJson([
                     'error' => 'Component not found'
                 ]);
    }

    /**
     * Test component path validation
     */
    public function test_component_path_validation()
    {
        // Test various path formats
        $validPath = 'pages/newsletter/newsletter_form.twig';
        $response = $this->get('/api/components/' . $validPath);

        // Should return 200 or 404, but not validation error
        $this->assertContains($response->status(), [200, 404]);
    }
}