<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class ComponentRegistryPageTest extends TestCase
{
    /**
     * Test component registry main page loads
     */
    public function test_component_registry_page_loads()
    {
        $response = $this->get('/components');

        $response->assertStatus(200)
                 ->assertHeader('Content-Type', 'text/html; charset=UTF-8');
    }

    /**
     * Test Vue.js component integration on registry page
     */
    public function test_vue_component_integration()
    {
        $response = $this->get('/components');

        $content = $response->getContent();

        // Verify Vue.js assets are loaded
        $this->assertStringContains('app.js', $content);
        $this->assertStringContains('app.css', $content);
    }

    /**
     * Test page performance meets requirements
     */
    public function test_page_performance()
    {
        $start = microtime(true);
        $response = $this->get('/components');
        $loadTime = microtime(true) - $start;

        $response->assertStatus(200);

        // Performance requirement: <5 seconds load time
        $this->assertLessThan(5.0, $loadTime, 'Component registry page should load in under 5 seconds');
    }

    /**
     * Test component registry handles no components gracefully
     */
    public function test_handles_no_components_gracefully()
    {
        // This test verifies behavior when no components are found
        $response = $this->get('/components');

        $response->assertStatus(200);

        // Page should still load even with no components
        $content = $response->getContent();
        $this->assertStringContains('Component Registry', $content);
    }

    /**
     * Test component registry navigation and routing
     */
    public function test_navigation_and_routing()
    {
        $response = $this->get('/components');

        $response->assertStatus(200);

        // Test that the route name is correct
        $this->assertEquals('component-registry', \Illuminate\Support\Facades\Route::currentRouteName());
    }
}