<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Category;
use Mtc\Shop\Item;
use Mtc\Shop\Item\Image;
use Mtc\Shop\Item\Size;

/**
 * @property string|int $id
 * @property string|int $ref
 */
class CatalogImport extends Model
{
    public const TYPE_ITEM = 'item';
    public const TYPE_ITEM_SIZE = 'item_size';
    public const TYPE_CATEGORY = 'category';
    public const TYPE_ITEM_IMAGE = 'item_image';

    public $timestamps = true;

    protected $table = 'catalog_import';

    protected $fillable = [
        'nodeable_type',
        'nodeable_id',
        'ref',
    ];

    public function nodeable()
    {
        return $this->morphTo();
    }

    public static function getClass(string $type)
    {
        switch($type) {
            case self::TYPE_CATEGORY:
                return Category::class;
            case self::TYPE_ITEM:
                return Item::class;
            case self::TYPE_ITEM_SIZE:
                return Size::class;
            case self::TYPE_ITEM_IMAGE:
                return Image::class;
            default:
                throw new \Exception('Unknow type!');
                break;
        }
    }
}
