<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\File;
use MtcPharmacy\Multisite\Classes\MultisiteSite;


class SitemapController extends Controller
{

    public static function index(Request $request)
    {
        $ms = MultisiteSite::find(SITE_ID);

        $filepath = $ms->getSitemapFilePath();

        $content = File::get(SITE_PATH . $filepath);

        return response($content)
            ->withHeaders([
                'Content-Type' => 'application/xml',
            ])
        ;
    }

}
