<?php

namespace App\Http\Middleware;

use Closure;

/**
 * Class AddHeaders
 *
 * @package App\Http\Middleware
 */
class AddHeaders
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $response = $next($request);

        // Headers already sent - this is very likely an output dump.
        // We cannot add new headers anymore
        if (headers_sent()) {
            return $response;
        }

        // Remove header which reports our PHP version within the response.
        // This has to be done old-school as it is server not application that sets this header
        header_remove('X-Powered-By');

        $response->headers->set('X-Frame-Options', 'SAMEORIGIN');
        $response->headers->set('X-XSS-Protection', '1; mode=block');
        $response->headers->set('X-Content-Type-Options', 'nosniff');
        $response->headers->set('Strict-Transport-Security', 'max-age=31536000; includeSubdomains');
        return $response;
    }
}
