<?php

namespace App;

use Mtc\Shop\Brand;
use Mtc\Shop\Category;
use Mtc\Shop\Item;

class MetaDataFactory
{
    private $seed_obj = null;


    public function __construct(object $seed_obj)
    {
        $this->seed_obj = $seed_obj;

        return $this;
    }


    public function getMetaTitle(string $default_title = "") : string
    {
        $title = null;

        $class_name = get_class($this->seed_obj);
        switch($class_name) {
            case Brand::class:
                $title = $this->seed_obj->seo_title;
                break;

            case Category::class:
                $title = $this->seed_obj->seo_title;
                break;

            case Item::class:
                $title = $this->seed_obj->seo_title;
                break;
        }

        return $title ?: $default_title;
    }


    public function getMetaDescription(string $default_description = "") : string
    {
        $description = $default_description;

        $class_name = get_class($this->seed_obj);
        switch($class_name) {
            case Brand::class:
                $description =  $this->seed_obj->seo_description;
                break;

            case Category::class:
                $description =  $this->seed_obj->seo_description;
                break;

            case Item::class:
                $description =  $this->seed_obj->seo_description;
                break;
        }

        return $description;
    }

}
