<?php

namespace App;

class SearchHelper
{

    public static function getFAQPagesByTerm($search_term)
    {
        $search_lister = \Search::newInstance()
           ->setLimit(10)
           ->setSearchTerm($search_term)
           ->setCurrentPage(1)
           ->run()
        ;

        $search_lister->getListing();

        $pages = collect($search_lister->list);

        $pages = $pages->reject(function($page){
            return $page->template != 'faqs_question.twig';
        });

        $pages = $pages->toArray();
        $pages = array_values($pages);

        return $pages;
    }

}
