<?php
/**
 * Content Manager Panel Page History Tab
 * @author Rihards Siliņš
 * @copyright MTC media Ltd.
 * @version 2 18/02/2016
 */
$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");

$p = new Page();
if (isset($_GET['page_id']) && is_numeric($_GET['page_id'])) {
    $p->get($_GET['page_id']);
} else {
    die("Page not found.");
}

$lister = Listing::newInstance()
    ->onlyPublished(false)
    ->onlyDefaultPages(false)
    ->setFilter([
        "`pages`.`type` = 'history'",
        " `pages`.`draft_for_page_id` = ".$p->id." "
    ])
    ->setOrder([
        " `pages`.`updated` DESC "
    ])
    ->run()
;

$lister->getListing();

?>
<p>
    These are all the page versions. These get automatically deleted -
    <?php
    if (strpos(CMS_PAGE_VERSIONING_HISTORY_LIMITS, "AGE") !== false) {
        echo "once they get older than ".CMS_PAGE_VERSIONING_HISTORY_LIMIT_AGE." days";
    }
    if (strpos(CMS_PAGE_VERSIONING_HISTORY_LIMITS, "AGE") !== false && strpos(CMS_PAGE_VERSIONING_HISTORY_LIMITS, "COUNT") !== false) {
        echo " or ";
    }
    if (strpos(CMS_PAGE_VERSIONING_HISTORY_LIMITS, "COUNT") !== false) {
        echo "when there are more than ".CMS_PAGE_VERSIONING_HISTORY_LIMIT_COUNT ." version for a page";
    }
    echo ". ";
    ?>
    Publishers may also lock the version to prevent it from being deleted automatically. Existing versions cannot be overwritten, only saved as new versions.
</p>
<div class="historyContainer clearfix" id="historyContainer">
    <a href="#" class="hidden-preview-page-btn" style="display:none">&nbsp;</a>
    <table>
        <tbody class="tabular">
            <?php
            $name = "<strong>".clean_page($p->title)."</strong> made current";
            if (!empty($p->author_name)) {
                $name .= " by <strong>".clean_page($p->author_name)."</strong>";
            }
            $updated_datetime = date_create_from_format("Y-m-d H:i:s", $p->updated);
            if (!empty($updated_datetime)) {
                $name .= " ".util::human_time_diff($updated_datetime->format("U"));
                $name .= " (".$updated_datetime->format("H:i jS F Y").")";
            }

            if (!empty($p->versions)) {
                $parent_versions = explode(" ", $p->versions);
                $current_version_was_created_from_version = 0;
                if (!empty($parent_versions)) {
                    $current_version_was_created_from_version = $parent_versions[(count($parent_versions)-1)];
                }
            }

            ?>
            <tr class="liveVersionAtTheTop">
                <td><strong>Current Page</strong></td>
                <td><?=clean_page($p->comment)?></td>
                <td><?=$name?></td>
                <td class="justCentered">
                    <a href="?page=<?=$p->id?>" class="viewVersion" data-page-id="<?=$p->id?>">
                        <i class="fa fa-external-link"></i>
                    </a>
                </td>
            </tr>
        </tbody>
    </table>
    <?php
    if (count($lister->list) > 0) {
        ?>
        <table class="manage-items pageVersions">
            <tr>
                <th>Version</th>
                <th></th>
                <th></th>
                <th class="justCentered">Mark Reviewed</th>
                <th class="justCentered">Preview</th>
                <th class="justCentered">View</th>
                <?php
                if ($_SESSION['content_manager']['is_mtcadmin'] == true || $_SESSION['content_manager']['is_publisher'] == true) {
                    ?><th class="justCentered">Delete</th>
                    <th class="justCentered">Lock</th>
                    <?php
                }
                ?>
            </tr>
            <tbody class="tabular">
                <?php
                foreach ($lister->list as $page) {;
                    $version = $page->id;
                    if ($page->id == $current_version_was_created_from_version) {
                        $version = "<strong>Current ".$page->id."</strong>";
                    }

                    $page_title = $page->title;
                    if (strlen($page->title) > 40) {
                        $page_title = substr($page->title, 0, 40)."...";
                    }

                    $updated_datetime = date_create_from_format("Y-m-d H:i:s", $page->updated);

                    $page_id = $page->draft_for_page_id;
                    $page_version_id = $page->id;
                    $include_comment = true;
                    $include_actions = true;
                    $include_mark_reviewed_action = true;
                    $text = "created";
                    include("table_version_row.php");
                }
                ?>
            </tbody>
        </table>
        <?php
    }
    ?>
</div>
