<?php

use Mtc\Shop\SeoDefault;

$path = '../../../';
require $path.'core/includes/header.inc.php';

//initialize variables
if (!isset($_REQUEST['action'])) {
    $_REQUEST['action'] = null;
}
if (!isset($_REQUEST['edit'])) {
    $_REQUEST['edit'] = '';
}
$errors = null;

$page_meta['title'] = 'Manage SEO Defaults';

$seoDefaults = new SeoDefaults();
$errors = array();
$defaults = array();
$form = array();

if ($_REQUEST['edit']) {
    $form = $seoDefaults->getDefault($_REQUEST['edit']);
}

if ($_REQUEST['action'] == 'update') {
    if (!$_REQUEST['title']) {
        $errors[] = 'Default title must not be empty';
    }
    if (!$_REQUEST['description']) {
        $errors[] = 'Default description must not be empty';
    }

    $form['title'] = $_REQUEST['title'];
    $form['description'] = $_REQUEST['description'];

    if (count($errors) === 0) {
        $seoDefaults->updateDefault($_REQUEST['id'], $_REQUEST['title'], $_REQUEST['description']);
        header('Location: manage.seo.defaults.php?message=success');
        exit;
    }
}

$defaults = SeoDefault::all()
    ->toArray();

require_once $path.'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/admin/seoadmin">Manage SEO</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>Default SEO</h1>
<?php
include 'tabnav.php';

if (count($errors) > 0) {
    showerrors($errors);
}
if (count($errors) == 0 && isset($_REQUEST['message']) && $_REQUEST['message'] == 'success') {
    echo showmsg("Operation carried out successfully", "success", $path);
}
?>

<?php
if ($_REQUEST['edit']) {
    ?>
    <form action="<?= $_SERVER['PHP_SELF'] ?>" method="post" class="style">
        <fieldset>
            <div class="row">
                <label for="path">Default <?= clean_page(ucfirst($form['name'])) ?> SEO:</label>
                <input type="hidden" name="id" value="<?= clean_page($form['id']) ?>" />
                <?php
                if (in_array($form['name'], ['fallback'])) {
                    ?>
                    <div class="hint el">
                        <i class="fa fa-info-circle"></i>
                        <div style="display: none;" class="text">
                            <h1>Purpose:</h1>
                            <p>
                                This is the ultimate fallback if no other rule can be matched.
                            </p>
                        </div>
                    </div>
                    <?php

                }
    ?>
            </div>
            <div class="row">
                <label for="title">Title</label>
                <input type="text" name="title" id="title" value="<?= clean_page($form['title']); ?>">
            </div>
            <div class="row">
                <label for="description">Description</label>
                <input type="text" name="description" id="description" value="<?= clean_page($form['description']); ?>">
            </div>
            <input type="hidden" name="action" value="update">
            <?php
            if ($_REQUEST['edit']) {
                ?>
                <input type="hidden" name="edit" value="<?= $_REQUEST['edit'] ?>">
                <?php

            }
    ?>
            <div class="search-button"><input type="submit" value="<?= (!$_REQUEST['edit']) ? 'Add' : 'Submit' ?>" class="BUTTON"/></div>
        </fieldset>
    </form>
    <?php

}

if (!$_REQUEST['edit'] && count($defaults) > 0) {
    ?>
    <table class="">
        <tr>
            <th class="center"></th>
            <th>Type</th>
            <th>Title</th>
            <th>Description</th>
            <th class="center"></th>
        </tr>
        <tbody class="tabular ui-sortable">
            <?php
            foreach ($defaults as $default) {
                ?>
                <tr>
                    <td>
                        <a href="<?= $default['path'] ?>" target="_blank"><i class="fa fa-eye"></i></a>
                    </td>
                    <td><?= clean_page($default['name']) ?></td>
                    <td><?= clean_page($default['title']) ?></td>
                    <td><?= clean_page($default['description']) ?></td>
                    <td>
                        <a href="?edit=<?= $default['id'] ?>"><i class="fa fa-pencil"></i></a>
                    </td>
                </tr>
                <?php

            }
    ?>
        </tbody>
    </table>

    <?php

} elseif (count($defaults) == 0) {
    ?>
    <p>No defaults have been defined</p>
    <?php

}
require_once $path.'core/admin/templates/adminfooter.html.php';
