<?php

$path = '../../../';
require $path.'core/includes/header.inc.php';

$page_meta['title'] = 'SEO Help';

require_once $path . 'core/admin/templates/adminheader.html.php';

?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>SEO Help</h1>
<?php
include 'tabnav.php';
?>
<div>
    <h2>Rule Processing</h2>
    <p>
        The following list outlines the order in which the script will process rules. As soon as a match against a given condition has been made, subsequent rules will be ignored.
    </p>
    <ol>
        <li>
            <b>Exact URI</b> - If the requested page URI can be matched exactly against a defined page rule.
        </li>
        <li>
            <b>Brand</b> (browse only) - If one (and only one) brand is selected on the browse page.
        </li>
        <li>
            <b>Category</b> (browse only) - If one category or a part of path (e.g. subcat --> subsubcat) in category tree is selected on the browse page.
        </li>
        <li>
            <b>Approximate URI</b> - Fetches all page rules that fit into the requested page's URI and then chooses the longest match
        </li>
        <li>
            <b>Script name</b> - If the current file's script name matches a page rule. Eg, all browse pages run on /browse/index.php.
        </li>
        <li>
            <b>Default</b> - Default rules are applied for the defined scenarios.
        </li>
    </ol>
</div>
<br />
<div>
    <h2>Keywords</h2>
    <p>
        Keywords are special reserved words the SEO admin will pick up on, and wherever possible replace with a given value.
    </p>
    <p>
        A list of supported keywords is:
    </p>
    <table>
        <tr>
            <th>{SITE_NAME}</th>
            <td>name of the site</td>
        </tr>
        <tr>
            <th>{BRAND}</th>
            <td>name of the brand</td>
        </tr>
        <tr>
            <th>{CATEGORY}</th>
            <td>name of the category</td>
        </tr>
        <tr>
            <th>{CATEGORIES}</th>
            <td>name of the categories in the format bottom level | ... | top level</td>
        </tr>
        <tr>
            <th>{PAGE}</th>
            <td>page number, browse pages only</td>
        </tr>
        <tr>
            <th>{ITEM}</th>
            <td>name of the item</td>
        </tr>
        <tr>
            <th>{FILE_NAME}</th>
            <td>Name of the file with CamelCasing as well as special characters (such as ., - or _) replaced by spaces and the file extension removed</td>
        </tr>
        <tr>
            <th>{PAGE_TITLE}</th>
            <td>CMS page title, CMS pages only</td>
        </tr>
        <tr>
            <th>{PAGE_CONTENT}{&lt;CUTOFF&nbsp;CHARS&gt;}</th>
            <td>
                CMS page Content shortened to a maximum of <CUTOFF CHARS> while not cutting in the middle
                of the last word and appending … at the end/replacing ?/!/. if it's last char.
                If Content is not available, falls back to <page title> | SITE_NAME. Example: {PAGE_CONTENT}{155}
            </td>
        </tr>
    </table>
    <p>
        Note that certain keywords will only work on certain pages, e.g. {ITEM} only works on item pages.
    </p>
    <p>
        Keywords that could not be found are removed.
    </p>
</div>
<br />
<div>
    <h2>CSV Import</h2>
    <p>Page rules, brand rules and category rules can be batch edited using the CSV import feature.</p>
    <p>The expected format is the same as that generated by the CSV export feature.</p>
    <p>Note that for existing entries the name/path and id are for ease of use only, they cannot be changed.</p>
    <p>Only title and description can be amended through the import.</p>
    <p>The exception to this rule is the page rule import, which will generate a new rule if you leave out the ID - assuming that the given path does not exists already.</p>
    <p>Note that for all imports the script will simply ignore rules in the system that are not in the import file.</p>
    <p>Also note that it is not possible to add, edit or remove brands and categories here.</p>
</div>
<div>
    <h2>SEO Redirects</h2>
    <p>URLs must start with a forward slash.</p>
    <p>CSV import format: redirect_code, old_url, new_url</p>
    <p>Available redirect codes: 301, 302, 303, 307</p>
</div>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
