<?php
/**
 * Helps you with populating site with dummy content images. Saving you from actually uploading and resizing dummy images.
 * When generating dummy content programmatically you can save fake_image.png to the database. Whem retrieved - it shall
 * pick up on what size your requesting it based off of the path and retrieve a dummy image in that size.
 *
 * Can also be used for theme or database default content.
 *
 * Required .htaccess rule:
 * RewriteRule fake_image\.png$ /image_faker.php [L]
 *
 * Usage:
 * $my_object = new MyObject();
 * $my_object->image = 'fake_image.png';
 * $my_object->save();
 *
 * If you are loading several fake images on one page and you'd like them to be different or specific you may append a
 * category (abstract,animals,business,cats,city,food,nightlife,fashion,people,nature,sports,technics,transport,technics)
 * by setting it in the file name - like this 'fake_image_sports.png'
 *
 * Append a number 1-10 'fake_image_sports_1.png' to get picture 1/10 out of specified category.
 *
 * @version 1 05/05/2017
 * @author Rihards Siliņš
 */

$path = '../../';
$exclude_header_inc = [
    'cms'                       => true,
    'shop'                      => true,
    'cross_platform_controller' => true
];
require_once $path . "core/includes/header.inc.php";

if (!defined('IMAGE_FAKER') || IMAGE_FAKER == false || DEV_MODE == false) {
    exit();
}

$requested_image_path = dirname(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));

$resource = "https://lorempixel.com";

foreach ($image_folders as $image_folder_group) {
    foreach ($image_folder_group as $image_folder) {
        if ("/" . $image_folder['path'] == $requested_image_path) {
            if (empty($image_folder['width']) && empty($image_folder['height'])) {
                $resource_image_url = $resource . "/800/800/";
            } elseif (empty($image_folder['width'])) {
                $resource_image_url = $resource . "/" . $image_folder['width'] . "/";
            } elseif (empty($image_folder['height'])) {
                $resource_image_url = $resource . "/" . $image_folder['height'] . "/";
            } else {
                $resource_image_url = $resource . "/" . $image_folder['width'] . "/" . $image_folder['height'] . "/";
            }
            if (!empty($_GET['category']) && preg_match("/^[a-z]{1,10}$/", $_GET['category'])) {
                $resource_image_url = $resource_image_url . $_GET['category'] . "/";
                if (!empty($_GET['picture_no']) && preg_match("/^[0-9]{1,2}$/", $_GET['picture_no'])) {
                    $resource_image_url = $resource_image_url . $_GET['picture_no'] . "/";
                }
            }
            header("Location: " . $resource_image_url);
            exit();
        }
    }
}

header("HTTP/1.0 400 Bad Request");
die("Image path (" . $requested_image_path . ") not found in image_folders variable!");
