<?php

namespace Mtc\Core\Keywords;

use Illuminate\Database\Eloquent\Collection;

/*
 * Keyword Collection Class.
 * Eloquent Collection extension for Keywords.
 *
 * @author Aleksey Lavrinenko <aleksey.lavrinenko@mtcmedia.co.uk>
 *
 */
class KeywordCollection extends Collection
{
    /**
     * Returns the collection as array of keyword strings
     * @return array
     */
    public function toStrings()
    {
        $result = [];
        foreach ($this as $keyword) {
            $result[] = $keyword->keyword;
        }
        return $result;
    }
}
