<?php
namespace Mtc\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

/**
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class SeoHeading extends Model
{
    protected $table = 'seo_headings';
    public $timestamps = false;

    protected $fillable = [
        'path',
        'text',
    ];

    /**
     * Boot method to clear SEO cache when data changes
     */
    protected static function boot()
    {
        parent::boot();

        // Clear cache for the specific path
        static::saved(function ($model) {
            $cache_key = 'seo_data_' . md5($model->path);
            Cache::forget($cache_key);
        });

        static::deleted(function ($model) {
            $cache_key = 'seo_data_' . md5($model->path);
            Cache::forget($cache_key);
        });
    }
}
