<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Modules\Members\Models\Member;
use Mtc\Modules\Members\Models\MembersAddress;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class MemberAddressFactory extends Factory
{
    protected $model = MembersAddress::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
        ];
    }

    function billing()
    {
        return $this->state(function (array $attributes) {
            return [
                'type' => 'billing',
                'firstname' => fake()->firstName(),
                'middle_name' => '',
                'lastname' => fake()->lastName(),
                'address1' => fake()->streetAddress(),
                'address2' => '',
                'city' => fake()->city(),
                'state' => '',
                'country' => fake()->country(),
                'postcode' => fake()->postcode(),
            ];
        });
    }

    function shipping()
    {
        return $this->state(function (array $attributes) {
            return [
                'type' => 'shipping',
            ];
        });
    }
}
