<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end">Manage <?= $page_name ?>s</li>
</ul>
<h1>Manage <?= $page_name ?>s</h1>

<?php
require __DIR__ . '/tabnav.php';
/** @var \Mtc\Modules\BasketRecovery\Classes\BasketRecovery $item */
showerrors($errors);

if (!empty($_SESSION['message'])) {
    echo showmsg($_SESSION['message'], 'success', $path);
    unset($_SESSION['message']);
}
?>

<form method="POST" enctype="multipart/form-data" class="style js-vue-environment">

    <fieldset class="show">
        <h1><a class="show el">Follow-up Content <i class="fa fa-caret-down"></i></a></h1>

        <section>

            <div class="row">
                <label for="name">Name</label>
                <input type="text" name="name" id="name" value="<?= clean_page($item->name) ?>" class="INPUT1">
            </div>

            <follow-up-type inline-template type="<?= $item->type ?>">
                <div v-cloak>
                    <div class="row">
                        <label for="type">Type</label>
                        <select name="type" id="type" v-model="type">
                            <option value="">Choose Type</option>
                            <option value="both">Both</option>
                            <option value="email">Email</option>
                            <option value="sms">SMS</option>
                        </select>
                    </div>
                    <div class="row" v-if="type != 'sms'">
                        <label for="subject">Email Subject</label>
                        <input type="text" name="subject" id="subject" value="<?= clean_page($item->subject) ?>" class="INPUT1">
                    </div>

                    <div class="row" v-show="type != 'sms'">
                        <label for="input-content">Email Content</label>
                        <textarea class="simpletinymce"
                                  id="input-content"
                                  name="content"><?= clean_page($item->content) ?></textarea>
                        <div class="el hint">
                            <i class="fa fa-info-circle"></i>
                            <div class="text">
                                Following tags are supported:
                                <?php
                                foreach (\Mtc\Modules\BasketRecovery\Classes\BasketRecoveryEmail::$replace_tags as $tag) {
                                    echo $tag . "<br/>";
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                    <div class="row" v-if="type != 'email'">

                        <label for="input-content">Message</label>
                        <textarea id="input-content"
                                  name="sms_content"><?= clean_page(strip_tags($item->sms_content ?? '')) ?></textarea>
                    </div>

                    <div class="row">
                        <label for="button_url">Button URL</label>
                        <input type="text" name="button_url" id="button_url" value="<?= $item->button_url ?>" class="INPUT1">
                    </div>

                    <div class="row">
                        <label for="button_copy">Button copy</label>
                        <input type="text" name="button_copy" id="button_copy" value="<?= $item->button_copy ?>" class="INPUT1" placeholder="Resume your order">
                    </div>

                    <div class="row">
                        <label for="is_button_visible">Button visible?</label>
                        <input type="hidden" name="is_button_visible" value="0" class="INPUT1">
                        <input type="checkbox"
                               name="is_button_visible"
                               id="is_button_visible"
                               value="1"
                               class="INPUT1"
                            <?= ($item->is_button_visible ? 'checked' : '') ?>>
                    </div>

                </div>
            </follow-up-type>

            <div class="row">

                <?php
                $interval = explode(' ', $item->interval ?? '');
                ?>

                <label for="interval_unit">Delay</label>
                <select name="interval_unit" id="interval_unit" style="width: 100px;">
                    <?php
                    for ($i = 1; $i <= 120; ++$i) {
                        ?>
                        <option <?= $interval[0] == $i ? 'selected' : '' ?>><?= $i ?></option>
                        <?php
                    }
                    ?>
                </select>
                &nbsp;
                <select name="interval_measure" style="width: 100px;">
                    <?php
                    foreach ($item->getIntervalsAllowed() as $measure) {
                        ?>
                        <option <?= ($interval[1] ?? null) == $measure ? 'selected' : '' ?>><?= clean_page($measure) ?></option>
                        <?php
                    }
                    ?>
                </select>

            </div>
            <div class="row">
                <label for="trigger">
                    Trigger
                </label>
                <select name="trigger" id="trigger">
                    <?php
                    foreach ($item->getTriggers() as $key => $trigger) {
                        ?>
                        <option value="<?= $key ?>" <?= $item->trigger == $key ? 'selected' : '' ?>>
                            <?= ucwords($trigger) ?>
                        </option>
                        <?php
                    }
                    ?>
                </select>
            </div>

            <follow-up-restrictions inline-template
                                    restriction_type="<?= clean_page($item->restriction_type) ?>"
                                    restriction_id="<?= (int)$item->restriction_id ?>">
                <div>
                    <div class="row">
                        <label for="restriction_type">
                            Enable for
                        </label>
                        <select name="restriction_type"
                                v-model="restriction_type"
                                @change="load()"
                                id="restriction_type">
                            <?php
                            foreach ($item->getRestrictions() as $key => $restriction) {
                                ?>
                                <option value="<?= $key ?>">
                                    <?= $restriction ?>
                                </option>
                                <?php
                            }
                            ?>
                        </select>
                    </div>
                    <div class="row" v-show="restriction_type != 'all_products' && restriction_type != ''">
                        <label for="restriction_id">
                            Select restriction
                        </label>
                        <select name="restriction_id"
                                v-model="restriction_id"
                                id="restriction_id">
                            <option value="0">-- select --</option>
                            <option :value="rr.id" v-for="rr in restrictions" v-text="rr.name"></option>
                        </select>
                    </div>
                </div>
            </follow-up-restrictions>

            <div class="row">
                <label for="is_active">Is Active?</label>
                <input type="hidden" name="is_active" value="0" class="INPUT1">
                <input type="checkbox"
                       name="is_active"
                       id="is_active"
                       value="1"
                       class="INPUT1"
                    <?= ($item->is_active ? 'checked' : '') ?>>
            </div>

            <div class="row">
                <label for="once_per_customer">Once per Customer?</label>
                <input type="hidden"
                       name="once_per_customer"
                       value="0"
                       class="INPUT1">
                <input type="checkbox"
                       name="once_per_customer"
                       id="once_per_customer"
                       value="1"
                       class="INPUT1"
                    <?= $item->once_per_customer ? 'checked' : '' ?>>
            </div>

        </section>

    </fieldset>

    <?php
    if (config('ecom.followups.coupon.enabled')) {
        ?>
        <fieldset class="show">
            <h1><a class="show el">Coupon <i class="fa fa-caret-right"></i></a></h1>
            <div class="row">
                <label for="coupon_type">Type</label>
                <select name="coupon_data[type]" id="coupon_type">
                    <?php
                    $options = [
                        '' => 'None (Disabled)',
                        'set' => 'Set Discount',
                        'percent' => 'Percent Off',
                    ];
                    foreach ($options as $key => $option) {
                        $selected = '';
                        if ($item->coupon_data && $key == $item->coupon_data['type']) {
                            $selected = 'selected';
                        }
                        ?>
                        <option <?= $selected ?> value="<?= clean_page($key) ?>"><?= clean_page($option) ?></option>
                        <?php

                    }
                    ?>
                </select>
            </div>

            <div class="row">
                <label for="coupon_value">Value (&pound;/%)</label>
                <input type="number" min="0" step="0.01" name="coupon_data[value]" id="coupon_value"
                       value="<?= $item->coupon_data ? floatval($item->coupon_data['value']) : null ?>"/>
            </div>

            <div class="row">
                <label for="coupon_min_price">Minimum Price (&pound;)</label>
                <input type="number" min="0" step="0.01" name="coupon_data[min_price]" id="coupon_value"
                       value="<?= $item->coupon_data ? floatval($item->coupon_data['min_price']) : null ?>"/>
            </div>

            <div class="row">
                <label for="coupon_free_delivery">Include Free Delivery</label>
                <select name="coupon_data[free_delivery]">
                    <?php
                    $delivery_options = [
                        0 => 'No',
                        1 => 'Anywhere',
                        2 => 'UK Only',
                    ];

                    foreach ($delivery_options as $key => $option) {
                        $selected = '';
                        if ($item->coupon_data && $key == $item->coupon_data['free_delivery']) {
                            $selected = 'selected';
                        }
                        ?>
                        <option <?= $selected ?> value="<?= clean_page($key) ?>"><?= clean_page($option) ?></option>
                        <?php

                    }
                    ?>
                </select>
            </div>

        </fieldset>
        <?php

    }
    ?>

    <input type="hidden" name="action" value="edit"/>
    <input type="hidden" name="id" value="<?= $item->id ?>"/>

    <div class="row">
        <input type="submit" value="Save"/>
    </div>
</form>

<?php
if (config('ecom.followups.stats')) {
    $sent = $item->sentEmails()->count();
    $read = $item->logs()->where('action', '=', 'read')->count();
    $click = $item->logs()->where('action', '=', 'click')->count();
    ?>
    <h3>Email Stats</h3>

    <div class="clear">
        <table class="tabular emailStats">
            <tr>
                <th>Sent Emails</th>
                <td>
                    <?= (int)$sent ?>
                </td>
            </tr>
            <tr>
                <th>Read Emails</th>
                <td>
                    <?= (int)$read ?>
                    <?php
                    if ($sent > 0) {
                        ?>
                        (<?= round($read / $sent * 100) ?>%)
                        <?php
                    }
                    ?>

                </td>
            </tr>
            <tr>
                <th>Clicked Emails</th>
                <td>
                    <?= (int)$click ?>
                    <?php
                    if ($sent > 0) {
                        ?>
                        (<?= round($click / $sent * 100) ?>%)
                        <?php
                    }
                    ?>
                </td>
            </tr>
            <?php
            if (isset($recovery) && $recovery->trigger === 'cart') {
                ?>
                <tr>
                    <th>Sales</th>
                    <td>
                        <?= $item->logs()->where('action', '=', 'sale')->count(); ?>
                        (&pound;<?= sprintf('%.2f', $item->logs()->where('action', '=', 'sale')->sum('value')); ?>)
                    </td>
                </tr>
                <?php
            }
            ?>
        </table>
    </div>
    <?php

}
