<?php

namespace Mtc\Modules\DoctorSurgery\Classes;

use Mtc\Modules\Members\Models\Member;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'startnumber' => null,
    'act' => null,
    'id' => null,
]);

$page_meta['title'] = 'Uploaded doctor list';

if (is_numeric($_REQUEST['startnumber'])) {
    $startnumber = $_REQUEST['startnumber'];
} else {
    $startnumber = 0;
}

$action = filter_var($_REQUEST['act'], FILTER_SANITIZE_STRING);
$id = filter_var($_REQUEST['id'], FILTER_SANITIZE_NUMBER_INT);

if($action == 'deactivate' || $action == 'activate') {
    $doctor = DoctorSurgery::withTrashed()->where('id', '=', $id)->first();

    if($action == 'deactivate') {
        $doctor->delete();
    } else {
        $doctor->restore();
    }
}

$query = DoctorSurgery::query();
$query->withTrashed();
$query->orderBy('id', 'ASC');
(new ViewFixer())->resolvePaginationDependencies($twig);

$doctors = $query->paginate(25);

$doctors->appends($_GET);

$totalnumrows = $doctors->total();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end">Uploaded doctor list</li>
    </ul>

    <h1>Uploaded doctor list</h1>

    <?php
require 'tabnav.php';
if ($totalnumrows > 0) {
    ?>
    <table class="manage-items doctor-table">
        <tr>
            <th class="center">ID</th>
            <th>Code</th>
            <th>Area team name</th>
            <th>Practice name</th>
            <th>Status</th>
            <th>Contacts</th>
            <th></th>
        </tr>
        <tbody class="tabular">
        <?php
        foreach ($doctors as $doctor) {
            /* @var $member Member */
            ?>
            <tr id="rorder-<?= $doctor->id ?>"<?php if($doctor->trashed()) { ?> class="disabled"<?php } ?>>
                <td>
                    <?= clean_page($doctor->id) ?>
                </td>
                <td>
                    <?= clean_page($doctor->ods_code) ?>
                </td>
                <td>
                    <?= clean_page($doctor->area_team_name) ?>
                </td>
                <td><?= clean_page($doctor->practice_name) ?></td>
                <td><?= clean_page($doctor->status) ?></td>
                <td>
                    Address: <?= clean_page($doctor->address_1 . ' ' . $doctor->address_2 . ' ' . $doctor->address_3 . ', ' . $doctor->postcode); ?>

                    <?php
                    if (!empty($doctor->city)) {
                        echo ', ' . clean_page($doctor->city);
                    }
                    if (!empty($doctor->county)) {
                        echo ', ' . clean_page($doctor->county);
                    }
                    if (!empty($doctor->phone)) {
                        echo '<br />Phone: ' . clean_page($doctor->phone);
                    }
                    if (!empty($doctor->fax)) {
                        echo '<br />Fax: ' . clean_page($doctor->fax);
                    }
                    if (!empty($doctor->email)) {
                        echo '<br />Email: ' . clean_page($doctor->email);
                    }
                    if (!empty($doctor->website)) {
                        echo '<br />Website: <a href="' . clean_page($doctor->website) . '">' . clean_page($doctor->website) . '</a>';
                    }
                    ?>
                </td>

                <td>
                    <?php if($doctor->trashed()) { ?>
                        <a href="index.php?act=activate&id=<?php echo $doctor->id; ?>"><i class="fa fa-retweet"></i></a>
                    <?php } else { ?>
                        <a href="index.php?act=deactivate&id=<?php echo $doctor->id; ?>"><i class="fa fa-times-circle"></i></a>
                    <?php } ?>
                </td>
            </tr>
            <?php
        }
        ?>
        </tbody>
    </table>
    <?php
} else {
    ?>
        <p>There is no doctor data uploaded</p>
    <?php
}

echo $doctors->render();

require_once $path . 'core/admin/templates/adminfooter.html.php';
