Vue.component('editReviewType', {

    props: [
        'reviewTypeData',
        'forms',
        'types',
        'mediums',
        'categories',
        'routes',
    ],

    data: function() {
        return {
            reviewType: {
                name: '',
                form_id: null,
                category_id: null,
                medium: null,
                type: null,
            },
            loading: false,
            errors: {},
            success: false,
        };
    },

    mounted: function() {
        this.init();
    },

    methods: {
        init() {
            if (!this.reviewTypeData.id) {
                return;
            }
            this.reviewType = this.reviewTypeData;
        },
        store() {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.success = false;
            this.loading = true;

            let vm = this;

            this.$http.post(this.routes['admin-review-types-store'], this.reviewType)
                .then((response) => {

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        this.loading = false;
                        return;
                    }
                    if (data.success) {
                        vm.success = data.success;
                        vm.reviewType = data.reviewType;
                    }
                });
        },
    },
});
