Vue.component('patientSubscriptions', {

    props: [
        'routes',
    ],

    data: function() {
        return {
            subscriptions: [
                {
                    id: 2,
                    status: 'active',
                    product: '6 Month Weight Loss Guarantee Package',
                    notes: '',
                    date_from: '03.08.2024',
                    date_to: '02.02.2025',
                    duration: 6,
                    payments: [
                        {
                            id: 4,
                            status: 'complete',
                            amount: 241.00,
                            payment_date: '03.08.2024',
                        },
                        {
                            id: 5,
                            status: 'complete',
                            amount: 241.00,
                            payment_date: '03.09.2024',
                        },
                    ],
                },
                {
                    id: 1,
                    status: 'complete',
                    product: 'Wegovy injections Starter Pack Months 1-3',
                    notes: 'Consider switching to stronger medication',
                    date_from: '03.05.2024',
                    date_to: '02.08.2024',
                    duration: 3,
                    payments: [
                        {
                            id: 1,
                            status: 'complete',
                            amount: 241.00,
                            payment_date: '03.05.2024',
                        },
                        {
                            id: 2,
                            status: 'complete',
                            amount: 241.00,
                            payment_date: '03.06.2024',
                        },
                        {
                            id: 3,
                            status: 'complete',
                            amount: 241.00,
                            payment_date: '03.07.2024',
                        },
                    ]
                },
            ],
            loading: false,
            add: false,
            showAll: false,
        };
    },

    mounted: function() {
        this.init();
    },

    computed: {
        canLoadAll() {
            return this.subscriptions.length > 1 && !this.showAll;
        },
        activeSubscription() {
            if (!this.subscriptions.length) {
                return null;
            }
            for (let i = 0; i < this.subscriptions.length; i++) {
                if (this.subscriptions[i].status === 'active') {
                    return this.subscriptions[i];
                }
            }
            return null;
        },
    },

    methods: {
        init() {
            this.load();
        },
        addTreatment() {
            this.add = true;
        },
        cancel() {
            this.add = false;
        },
        load() {
            /*
            this.loading = true;
            let vm = this;

            this.$http.post(this.routes['admin-reviews-load'], [])
                .then((response) => {

                    const data = response.data;

                    vm.reviews = data.reviews;
                    vm.loading = false;
                });

             */
        },
        loadAll() {
            this.showAll = true;
        }
    },
});
