<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('member_notes', function (Blueprint $table) {
            $table->boolean('is_flag')->after('content')->default(false);
            $table->date('flag_due')->after('is_flag')->nullable();
            $table->string('status')->after('content')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('member_notes', function (Blueprint $table) {
            $table->dropColumn('is_flag');
            $table->dropColumn('flag_due');
            $table->dropColumn('status');
        });
    }
};
