<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('patient_bp_track', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('member_id');
            $table->unsignedBigInteger('file_id')->nullable();
            $table->integer('high');
            $table->integer('low');
            $table->integer('heart_rate');
            $table->date('date_provided');
            $table->timestamps();

            $table->foreign('file_id')
                ->references('id')
                ->on('patient_files')
                ->onDelete('SET NULL');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('patient_bp_track');
    }
};
