# Installation

Clone the repo
```bash
git clone https://YOUR_BITBUCKET_ACCOUNT@bitbucket.org/mtcmedia/core-plugins-googlemaps.git ~/public_html/plugins/GoogleMaps
```

include the map where needed

```bash
 {% include 'includes/map.twig' %}

```

# API key
You will need to generate google maps api key. Request clients google account login details, sign in with them and go to https://developers.google.com/maps/documentation/javascript/get-api-key

After that, hit the 'Get a key' button, create a new project and create API key:

1. Which API are you using? - google maps javascript key
2. Where will you be calling the API from? - web browse (Javascript)
3. hit 'What credentials do I need?'
4. Enter key name
5. Accept requests from these HTTP referrers (web sites)  - insert staging and live url here
6. Hit create

You will now have the api key copy it, open settings in admin and replace the GOOGLE_MAPS_JS_API_KEY

# Limits
Please view https://developers.google.com/maps/pricing-and-plans/#details
For the js API it's 25000 per 24h, for the geocoder it's only 2500. If limit is reached the maps API will stop functioning for the rest of the day.

# Edit the Template

1. copy the template into site templates/includes folder, find the map that is the closest to what you need. There is a bunch of examples to demonstrate options and possibilities. Clean up the rest from your modified template and clean up the mtc_maps.js
2. go to /plugins/GoogleMaps/js/mtc_maps.js and clean up stuff you don't need
3. replace the static places data with the dynamic data from cms/shop.

# Defaults

```javascript
defaults = {
    marker: {
        icon: null,
        width: null,
        height: null,
        origin_x: null,
        origin_y: null,
        anchor_x: null,
        anchor_y: null
    },
    info_box: {
        close_button_markup: '<button>x</button>',
        width: 200,
        offset_x: -100,
        offset_y: -50,
        align_bottom: true,
        close_on_click: true,
        disable_auto_pan: false,
        info_box_class: 'infobox'

    },
    search: {
        distance: 100,
        max_results: 3,
        no_results_markup: '<p>Sorry, no places nearby were found</p>',
        result_zoom: 8,
        search_results: '',
        search_form: '',
        autocomplete: false
    },
    map_options: {
        mapTypeId: google.maps.MapTypeId.ROADMAP,
        disableDefaultUI: false,
        scrollwheel: false
    },
    styles: null,
    touchbar: false,
    responsive: [
        {
            breakpoint: 640,
            settings: {
                map_options: {
                    zoomControl: false,
                    streetViewControl: true,
                    streetViewControlOptions: {
                          position: google.maps.ControlPosition.LEFT_BOTTOM
                    }
                },
                touchbar: true
            }
        }
    ]
};
```






