<?php

namespace Mtc\Plugins\MembersMessaging\Classes;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Order\Item;

class Templates extends Model
{
    /**
     * @var string[]
     */
    public static $categories = [
        'customer' => 'Customer',
        'automated' => 'Automated order processing',
        'contact_gp' => 'GP Communication',
    ];

    protected $table = 'messenger_templates';

    protected $fillable = [
        'name',
        'text',
        'role',
        'category',
    ];

    /**
     * @param $order_item_id
     * @return mixed|string|string[]
     */
    public function withOrderItemReplacements($order_item_id)
    {
        $item = Item::query()->find($order_item_id);
        return str_replace([
            '{{ORDER_ITEM_NAME}}',
            '{{ORDER_REFERENCE}}'
        ], [
            $item->item_name ?? '',
            $item->order->order_ref,
        ], $this->text);
    }
}