<?php


/*** EVENTS ***/

\Mtc\Plugins\MtcUnioIntegration\Classes\Helper::register_event_listeners();



/*** ROUTES ***/


/* API endpoints */

$unio_user = 'u'; // TODO
if (defined('UNIO_INCOMING_MESSAGES_USER')) {
    $unio_user = UNIO_INCOMING_MESSAGES_USER;
}

$unio_pass = 'p'; // TODO
if (defined('UNIO_INCOMING_MESSAGES_PASS')) {
    $unio_pass = UNIO_INCOMING_MESSAGES_PASS;
}

// curl <base_url>/api/v1/messages -H "Authorization: Basic $(echo -n <username>:<password> | base64)"

// curl -k https://www.local.vyne.mtcdevserver4.com/api/v1/messages -H "Authorization: Basic $(echo -n u:p | base64)" -H "Content-type: application/json" -d '{"entity_type":"order", "entity_id": 1234}'

Route::any('api/v1/messages', [
    'as' => 'api-v1-message',
    'uses' => 'Mtc\Plugins\MtcUnioIntegration\Http\Controllers\Api\QueueFromUnioController@messages'
])->middleware("auth.basic.mtc:{$unio_user},{$unio_pass}");


/* Admin pages */

Route::get('admin/unio/queue', function () {
    return redirect('admin/unio/queue/to-unio');
});

Route::get('admin/unio/queue/to-unio', [
    'as' => 'admin-unio-queue-to-unio',
    'uses' => 'Mtc\Plugins\MtcUnioIntegration\Http\Controllers\Admin\QueueController@to_unio'
]);

Route::get('admin/unio/queue/from-unio', [
    'as' => 'admin-unio-queue-from-unio',
    'uses' => 'Mtc\Plugins\MtcUnioIntegration\Http\Controllers\Admin\QueueController@from_unio'
]);


Route::get('admin/unio/queue/to-unio/{message_id}/payload', [
    'as' => 'admin-unio-queue-to-unio-get-payload',
    'uses' => 'Mtc\Plugins\MtcUnioIntegration\Http\Controllers\Admin\QueueController@to_unio_payload'
]);

Route::get('admin/unio/queue/to-unio/{message_id}/response', [
    'as' => 'admin-unio-queue-to-unio-get-response',
    'uses' => 'Mtc\Plugins\MtcUnioIntegration\Http\Controllers\Admin\QueueController@to_unio_response'
]);

Route::get('admin/unio/queue/from-unio/{message_id}/response', [
    'as' => 'admin-unio-queue-from-unio-get-response',
    'uses' => 'Mtc\Plugins\MtcUnioIntegration\Http\Controllers\Admin\QueueController@from_unio_response'
]);

Route::get('admin/unio/queue/from-unio/{message_id}/payload-received', [
    'as' => 'admin-unio-queue-from-unio-get-payload-received',
    'uses' => 'Mtc\Plugins\MtcUnioIntegration\Http\Controllers\Admin\QueueController@from_unio_payload_received'
]);
