<?php
namespace Mtc\Migrations;

use Mtc\Core\Models\MigrationTemplate;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Schema\Builder as SchemaBuilder;
use Illuminate\Database\Capsule\Manager as Capsule;


class AddNHSTables implements MigrationTemplate
{

    public function up(SchemaBuilder $schema)
    {
        if (!$schema->hasTable('nhs_members')) {
            $schema->create('nhs_members', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('member_id')->index();
                $table->integer('doctor_surgery_id')->index();
                $table->string('firstname');
                $table->string('lastname');
                $table->date('dob')->nullable();
                $table->string('gender', '20');
                $table->date('reminder_date');
                $table->tinyInteger('is_pay_for_prescriptions');
                $table->tinyInteger('is_property_safe');
                $table->tinyInteger('is_patient');
                $table->timestamps();
            });
        }

        $members_section = Capsule::table('admin_menu')->where('title', '=', 'Members')->first();
        // Create the admin menu item
        Capsule::table('admin_menu')->insert([
            'sub_id'     => $members_section->id,
            'title'      => 'NHS members',
            'path'       => '/plugins/NHS/admin',
            'activePath' => '/plugins/NHS/admin',
            'constant'   => 'MEMBERS_SECTION',
            'icon'       => 'fa fa-users',
            'new_window' => 0,
            'order'      => 5
        ]);

        return true;
    }

    public function getDescription()
    {
        return 'Add NHS tables';
    }

    public function down(SchemaBuilder $schema)
    {

    }

    public function getPrettyName()
    {
        return 'Add NHS tables';
    }

}
