export default {

    settings: {
        memberType: 'patient',
    },

    setMemberType: function(value) {
        this.settings.memberType = value;
    },

    getMemberType: function() {
        return this.settings.memberType;
    },


    strings: {

        page_1: {
            proceedButtonText: {
                referrer: 'Next: Tell us about your patient',
                patient: 'Next: Get to know you',
            },
            title: {
                referrer: 'Select the products you need',
                patient: 'Select the products you need',
            },
            introContent: {
                referrer: 'Search for your medications and/or appliances, and add them to your NHS prescription.',
                patient: 'Search for your medications and/or appliances, and add them to your NHS prescription.',
            },
            navTitle: {
                referrer: 'Step 1. Choose your  patient\'s prescription',
                patient: 'Step 1. Choose your prescription',
            },
            navSubtitle: {
                referrer: 'Add items to build your patient\'s prescription',
                patient: 'Add items to build your prescription',
            },
        },

        page_2: {
            introContent: {
                referrer: 'Please provide some basic details about you and or your patient.',
                patient: 'Please provide some basic details about you.',
            },
            title: {
                referrer: 'Tell us about your patient',
                patient: 'Getting to know you',
            },
            navTitle: {
                referrer: 'Step 2. Getting to know your patient',
                patient: 'Step 2. Getting to know you',
            },
            navSubtitle: {
                referrer: 'Your account and patient information',
                patient: 'Your account information',
            },
        },
        page_3: {
            proceedButtonText: {
                referrer: 'Next: More about your patient',
                patient: 'Next: More about you',
            },
            backButtonText: {
                referrer: 'Prev: Patient account details',
                patient: 'Prev: Your account details',
            },
            introContent: {
                referrer: 'Use the map below to search for the right GP surgery.',
                patient: 'Use the map below to search for and add your GP surgery.',
            },
            title: {
                referrer: 'Find your patient\'s GP',
                patient: 'Find your GP',
            },
            navTitle: {
                referrer: 'Step 3. Finding your patient\'s GP',
                patient: 'Step 3. Finding your GP',
            },
            navSubtitle: {
                referrer: 'Your patient\'s GP Surgery location',
                patient: 'Your GP Surgery location',
            },
        },
        page_4: {
            introContent: {
                referrer: 'Please provide more information about you as well as your home and delivery address.',
                patient: 'Please provide more information about your patient as well as your home and delivery address.',
            },
            title: {
                referrer: 'More about your patient',
                patient: 'More about you',
            },
            navTitle: {
                referrer: 'Step 4. More about your patient',
                patient: 'Step 4. More about you',
            },
            navSubtitle: {
                referrer: 'Further information and addresses',
                patient: 'Further information and addresses',
            },
            exemptText: {
                referrer: 'Tick if they <strong>are</strong> exempt from paying for prescription',
                patient: 'Tick if you <strong>are</strong> exempt from paying for prescription',
            },
            categoriesText: {
                referrer: 'Do they fall into any of these four categories?',
                patient: 'Do you fall into any of these four categories?',
            },
            shippingToggleText: {
                referrer: 'Their shipping information is the same as their billing information.',
                patient: 'My shipping information is the same as my billing information.',
            },
            shippingToggleContent: {
                referrer: 'If they have small children, pets or others who could be at risk at the property, please consider using a different delivery address. Please note controlled drugs and refrigerated items will require a signature upon delivery.',
                patient: 'If you have small children, pets or others who could be at risk at the property, please consider using a different delivery address. Please note controlled drugs and refrigerated items will require a signature upon delivery.',
            },
            newPrescriptionText: {
                referrer: 'Need to add more patients?',
                patient: 'Need to add more prescriptions?',
            },
            newPrescriptionButtonText: {
                referrer: 'New patient',
                patient: 'New prescription',
            },
            dataTitle: {
                referrer: "Your patient's data",
                patient: 'Your data',
            },
            offersQuestion: {
                referrer: "Would your patient like to be kept up to date with service annoucements, advice and updates?",
                patient: "Would you like to be kept up to date with service annoucements, advice and updates?",
            },
        },
        page_5: {
            navTitle: {
                referrer: 'Step 5. Confirm order',
                patient: 'Step 5. Confirm order',
            },
            navSubtitle: {
                referrer: 'Manage and confirm your patient\'s orders',
                patient: 'Manage and confirm your orders',
            },
            newPrescriptionText: {
                referrer: 'Need to add more patients?',
                patient: 'Need to add more prescriptions?',
            },
            newPrescriptionButtonText: {
                referrer: 'New patient',
                patient: 'New prescription',
            },
            confirmPopupText: {
                referrer: "If you've provided us with your patients email address, they'll receive a confirmation and we'll let them know when their items are on their way. You can keep track of all your orders in your dashboard though, so you can stay in the loop too!",
                patient: "",
            },
        }

    },

    get_string: function(page_key, string_key) {
        let str = "-";
        try {
            str = this.strings[page_key][string_key][this.settings.memberType];
        } catch(e) {
            console.error("Couldn't find [config.strings." + page_key + "." + string_key + "] string.");
        }

        return str;
    },

}
