<?php

namespace Mtc\Plugins\NewsletterSignup\Classes;

/**
 * Class NewSubscriberEvent
 *
 * This is an event class. Used to fire and handle an "New Subscriber" event.
 * An instance of this class is passed to event handlers that subscribe to this event.
 *
 * @author  Haroldas Latonas <haroldas.latonas@mtcmedia.co.uk
 * @version 2017-10-16
 */
class NewSubscriberEvent
{

    /**
     * @var mixed
     */
    protected $email;

    /**
     * @var mixed
     */
    protected $full_name;

    /**
     * @var mixed
     */
    protected $last_name;

    /**
     * @param array $request request array
     */
    public function __construct($request)
    {
        $this->email    = $request['newsletter_email'];
        $this->full_name = $request['newsletter_first_name'];
        $this->last_name = $request['newsletter_surname'];
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @return string
     */
    public function getFullName()
    {
        return $this->full_name;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->last_name;
    }
}
