function dontShowAgain() {
    "use strict";

    // setCookie to stop popup from showing again
    if ($('.newsletterPopupButton').attr('data-show-once') === 1) {
        // this cookie will expiry in 1year
        $.cookie('newletterPopupDontShow', 1, {
            expires: 365,
            path: '/'
        });
    } else {
        // this cookie will expire when the session ends
        $.cookie('newletterPopupDontShow', 1, {
            path: '/'
        });
    }
}

function triggerClickNewsletterPopup() {
    "use strict";

    $('.newsletterPopupButton').trigger('click');
}

$('document').ready(function () {
    "use strict";

    // newsletter form
    if ($('.newsletterForm').length || $('.newsletterPopupButton').length) {
        submitForm('.newsletterForm');
    }

    /**
     * trigger click of .newsletterPopupButton
     * only if POPUP is set to true in settings
     */
    if ($('.newsletterPopupButton').length) {
        $('.newsletterPopupButton').on('click', function (e) {
            e.preventDefault();

            // append overlay background and container to body
            $('body').append('<div class="newsletterPopupOverlay"></div>');

            var data = 'newsletter_popup=1';

            $.ajax({
                type: 'post',
                url: $(this).attr('href'),
                context: $(this),
                data: data,
                success: function (response) {
                    $('.newsletterPopupOverlay').html(response);

                    $('<div class="newsletterPopupOverlayCloseButton"><a href="#"><i class="fa fa-remove"></i></a></div>').prependTo($('.newsletterPopupOverlay'));

                    $('.newsletterPopupOverlay').animate({
                        bottom: 0
                    });
                }
            });
        });

        $(document).on('click', '.newsletterPopupOverlayCloseButton a', function (e) {
            e.preventDefault();

            var overlay_height = $('.newsletterPopupOverlay').outerHeight() + $('.newsletterPopupOverlayCloseButton').outerHeight();

            $('.newsletterPopupOverlay').animate({
                bottom: - overlay_height
            }, function () {
                $('.newsletterPopupOverlay').remove();
            });

            // set cookie to not show popup again
            dontShowAgain();
        });

        (function () {
            var $this = $('.newsletterPopupButton'),
                delay = $this.attr('data-delay'),
                page_visits = $this.attr('data-page-visits'),
                page_count;

            // update cookie on every other page load if set
            if ($.cookie('newsletterPopupPagesVisited') > 0) {
                page_count = $.cookie('newsletterPopupPagesVisited');
                page_count = parseInt(page_count);

                $.cookie('newsletterPopupPagesVisited', ++page_count, {
                    path: '/'
                });
            } else {
                // set cookie on first page load
                $.cookie('newsletterPopupPagesVisited', 1, {
                    path: '/'
                }); // setCookie
            }

            if ($.cookie('newsletterPopupPagesVisited') >= page_visits && !$.cookie('newletterPopupDontShow')) {
                // if cookie is set trigger
                setTimeout(triggerClickNewsletterPopup, delay);
            }
        }());
    }
});
