<?php
/**
 * Site Menu Installer
 *
 * This code is used to Install Site Menu on site
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Database\Capsule\Manager as Capsule;

if (empty($path)) {
    $path = '../../../';
    require_once $path . 'core/includes/header.inc.php';
}

$schema = Capsule::connection()->getSchemaBuilder();

if ($schema->hasTable('site_menu') === false) {
    $schema->create(
        'site_menu',
        function ($table) {
            $table->increments('id');
            $table->string('name');
            $table->integer('parent_id');
            $table->integer('published')->length(1);
            $table->string('target');
            $table->string('url');
            $table->integer('order');
            $table->string('css_class');
            $table->integer('category_list');
            $table->integer('brand_list');
            $table->integer('site_tree');
            $table->timestamps();

            $table->index('name');
            $table->index('parent_id');
            $table->index('published');
        }
    );
}

if (!defined('SITE_MENU_ENABLED')) {
    // Get the path to the admin folder without public_html / fork directory
    $path_to_admin_folder = str_replace(SITE_PATH, '', dirname(__DIR__)).'/admin/';

    // Create the admin menu item
    Capsule::table('admin_menu')->insert(
        [
        'sub_id'     => 1,
        'title'      => 'Site Menu',
        'path'       => $path_to_admin_folder,
        'activePath' => $path_to_admin_folder,
        'constant'   => 'SITE_MENU_ENABLED',
        'icon'       => 'fa fa-indent',
        'new_window' => 0,
        'order'      => 0,
        ]
    );

    $data = [
        [
            'key'         => 'SITE_MENU_ENABLED',
            'type'        => 'bool',
            'value'       => 1,
            'module'      => 'SITE_MENU',
            'description' => 'Turn on/off Site Menu',
            'created_at'  => new DateTime(),
        ],
        [
            'key'         => 'SITE_MENU_FIRST_CONTAINER_CLASS',
            'type'        => 'string',
            'value'       => 'mainMenu',
            'module'      => 'SITE_MENU',
            'description' => 'Turn on/off Site Menu',
            'created_at'  => new DateTime(),
        ]
    ];
    MTC\Core\Setting::Insert($data);
}
