# Qualifying Answers/Questions


## How to install

Add the following service provider class to `/config/app.php`:
`\MtcPharmacy\QualifyingAnswers\QualifyingAnswersServiceProvider::class` (for routes & migrations to work).

Run migrations (e.g. `php artisan migrate`)


### Issues

To discover the templates you might need to edit `/core/includes/header.inc.php`:

```php
$view_paths = Config::get('view.paths');

foreach ($view_paths as $view_path) {
    $template_paths[] = $view_path;
}
```

---

Include the assets if you wish: `assets/mtc_pharmacy_qualifying_answers.less` (e.g. create a symlink in your public directory).




## How to use

Download template with all questions/products (it can be used for import/export):

`<?= QualifyingAnswersHelper::renderDownloadTemplatesForm() ?>`

---

Edit qualifying answers per item:

`<?= QualifyingAnswersHelper::renderItemForm($item_eloquent) ?>`

---

Display allowed or hide rejected items (based on the provided assessment answers).

```php
$assessment = Assessment::getLatest();
$qa_filter = QualifyingAnswersFilter::init($assessment);

$qualified_items = $items->filter(function ($item) use ($qa_filter) {
    return in_array($item->id, $qa_filter->getQualifiedItemIDs());
});

$items = $items->reject(function ($item) use ($qa_filter) {
    return in_array($item->id, $qa_filter->getRejectedItemIDs());
});

```

