Vue.component('toggle-button', {

    props: [
        'values',
        'value',
    ],

    data: function() {
        return {
            currentIndex: undefined,
        };
    },

    methods: {

        nextLabel: function() {

            if ((this.currentIndex + 1) >= this.values.length) {
                this.currentIndex = 0;
            } else {
                this.currentIndex += 1;
            }

            this.$emit('input', this.values[this.currentIndex].id);

        },

    },

    watch: {
        value: {
            immediate: true,
            handler: function() {
                for (let i = 0; i < this.values.length; i++) {
                    if (this.values[i].id == this.value) {
                        this.currentIndex = i;
                        break;
                    }
                }
            },
        },
    },

    template: `
        <section>

            <button
                @click.prevent="nextLabel"
                v-html="values[currentIndex].label"
                :style="'width: 5em; padding: 0.2em 1.5em; background: ' + values[currentIndex].hex_rgb +'; border-radius: 3px;'"
            ></button>
        </section>
    `,

});
