<?php

use Mtc\Shop\Ingredient;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'id' => null,
]);

$display_form = true;

$errors = [];

$ingredient = (new Ingredient())->findOrNew($_REQUEST['id']);

$addedit = $_REQUEST['id'] ? 'Update' : 'Add';

$page_meta['title'] = $addedit . ' Ingredient';

if ($_REQUEST['action'] === 'save') {
    if (empty($_REQUEST['name'])) {
        $errors[] = 'Please specify name!';
    }
    if (empty($errors)) {
        $ingredient->fill($_REQUEST);
        $ingredient->save();
        header('location: manage.ingredients.php');
        exit;
    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="manage.ingredients.php">Manage Ingredients</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>Ingredient</h1>
<?php

include __DIR__ . '/tabnav.php';

if (count($errors)>0) {
    showerrors($errors);
}
    ?>

    <form action="" method="post" class="style">
        <fieldset class="show">
            <h1><a class="show el">Ingredient <i class="fa fa-caret-right"></i></a></h1>
            <div class="row">
                <label for="name">Ingredient</label>
                <input type="text" name="name" id="name" value="<?=clean_page($_REQUEST['name'] ?? $ingredient->name); ?>" class=""/>
            </div>
            <div class="row">
                <label for="strength">Limit type</label>
                <select name="limit_type">
                    <option value="tablets" <?= $ingredient->limit_type === 'tablets' ? 'selected' : ''; ?>>Tablets</option>
                    <option value="boxes" <?= $ingredient->limit_type === 'boxes' ? 'selected' : ''; ?>>Boxes</option>
                </select>
            </div>
            <div class="row">
                <label for="message">Message</label>
                <textarea name="message" id="message" class="simpletinymce"><?= $ingredient->message; ?></textarea>
            </div>
       </fieldset>
       <fieldset>
        <div class="save-button">
            <input type="hidden" name="action" value="save"/>
            <input type="submit" value="Save"/>
        </div>
       </fieldset>
    </form>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
