<?php
/**
 * Initialise
 */

use Mtc\Shop\OrderStatusEmailText;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'order_id' => null,
]);

$display_form = true;
$errors = [];

$orderStatusEmailText = OrderStatusEmailText::query()
    ->where('status_id', $_REQUEST['id'])
    ->firstOrNew();

$addedit = empty($_REQUEST['id']) ? 'Add' : 'Update';

$page_meta['title'] = $addedit . ' Order Status Email Text';

/**
 * Postback
 */

if ($_REQUEST['action'] == 'add') {
    $orderStatusEmailText->fill($_REQUEST);
    $orderStatusEmailText->save();
}

/**
 * Output
 */

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="manage.php">Manage Order Status Email Text</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1><?= clean_page($page_meta['title']) ?></h1>

<?php

include 'tabnav.php';

if ($display_form) {

    if (empty($errors) && isset($_REQUEST['action'])) {
        echo showmsg("Text updated", "success", $path);
    }

?>

    <form action="" method="post" enctype="multipart/form-data" class="style">
        <fieldset class="show">
            <h1>
                <a class="show el">
                    <?php

                    switch($_REQUEST['id']) {
                        case 0 :
                            echo 'Order Email';
                        break;
                        case 4:
                            echo 'Shipment Email';
                        break;
                        case 6 :
                            echo 'Refund Email';
                        break;
                    }

                    ?>
                    Text <i class="fa fa-caret-right"></i>
                </a>
            </h1>
            <div class="row">
                <label for="text">Text</label>
                <textarea name="text" rows="14" cols="50" class="linkOnlyTinyMce"><?= ($orderStatusEmailText->text ?? null) ?></textarea>
            </div>
        </fieldset>

        <div class="row">
            <input type="hidden" name="action" value="add"/>
            <input type="hidden" name="id" value="<?= $_REQUEST['id']; ?>"/>
            <input type="submit" value="Save"/>
        </div>

    </form>
<?php
} else {
?>
    <div>
        Order Status Text has been added/updated.
    </div>
    <?php
}

?>
<br class="clear" />
<div class="emailWrap">

    <h1>Email Preview</h1>

    <iframe class="previewTextIframe" src="email_preview.php?order_id=<?= clean_page($_REQUEST['order_id']) ?>&id=<?= clean_page($_REQUEST['id']) ?>"></iframe>

</div>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
