<?php

use Mtc\Shop\PropertyType;

$property_type_id = abs((int) $_REQUEST['propertyid']);

if (empty($property_type_id)) {
    header('Location: manage.properties.php');
    exit();
}

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$append = '&propertyid=' . $property_type_id;

$page_meta['title'] = 'Manage Property Values';
$section = 'shop';

$errors = [];

/*
  Delete The Brand
 */
if ($_REQUEST['action'] == 'delete' && is_numeric($_REQUEST['delete_id'])) {

    \Mtc\Shop\Property::query()
        ->where('id', '=', $_REQUEST['delete_id'])
        ->delete();

    header('Location: /shop/admin/properties/manage.property_values.php?page=' . $_GET['page'] . '&propertyid=' . $property_type_id . '&message=deleted');
    exit();
}

$propertyType = PropertyType::query()
    ->find($property_type_id);

$property_type_data = $propertyType->toArray();

require_once $path . 'core/admin/templates/adminheader.html.php';

?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="manage.properties.php">Item Properties</a> /</li>
    <li class="end">Manage <?= clean_page($property_type_data['name']) ?> Values</li>
</ul>

<h1>Manage <?= clean_page($property_type_data['name']) ?> Values</h1>

<?php
include 'valuetabnav.php';

if (sizeof($errors) > 0) {
    showerrors($errors);
}

$query = \Mtc\Shop\Property::query()
    ->where('property_type_id', '=', $property_type_id);

$totalnumrows = $query->count();

if (empty($_GET['page'])) {
    $_GET['page'] = 1;
}

$rowsPerPage = 25;
$pageNum = $_GET['page'];
$offset = ($pageNum - 1) * $rowsPerPage;
$pagestoshow = 10;

$properties = $query
    ->orderBy('order')
    ->orderBy('name')->skip($offset)
    ->limit($rowsPerPage)
    ->get();

if ($properties->count() > 0) {

    if ((sizeof($errors) == 0 && $_REQUEST['action'] == 'update') || $_REQUEST['message'] == 'update') {
        echo showmsg("Properties updated", "success", $path);
    } elseif ($_REQUEST['message'] == 'added') {
        echo showmsg("Values added", "success", $path);
    } elseif ($_REQUEST['message'] == 'deleted') {
        echo showmsg("Value removed", "success", $path);
    }
    ?>

    <form action="<?= $_SERVER['PHP_SELF']; ?>" method="post">
        <table class="manage-items">
            <tr>
                <th class="fieldname">Order</th>
                <th class="fieldname">Name</th>
                <th class="center">Edit</th>
                <th class="center">Delete</th>
            </tr>
            <tbody class="tabular ui-sortable">
                <?php
                foreach ($properties as $property) {
                    $data = $property->toArray();
                    $edit_params = [
                        'id' => $data['id'],
                        'propertyid' => $property_type_data['id'],
                        'page' => $_GET['page'] ? abs(((int) $_GET['page'])) : 1,
                    ];

                    $delete_params = [
                        'action' => 'delete',
                        'delete_id' => $data['id'],
                        'propertyid' => $property_type_data['id'],
                        'page' => $_GET['page'] ? abs(((int) $_GET['page'])) : 1,
                    ];

                    ?>
                    <tr id="rorder-<?= $data['id'] ?>">
                        <td class="center">
                            <i class="fa fa-arrows"></i>
                        </td>
                        <td>
                            <?= clean_page($data['name']) ?>
                        </td>
                        <td class="center">
                            <a href="edit.property_values.php?<?= http_build_query($edit_params) ?>"
                                class="edit picto"
                            >
                                <i class="fa fa-pencil"></i>
                            </a>
                        </td>
                        <td class="center">
                            <a href="manage.property_values.php?<?= http_build_query($delete_params) ?>"
                                class="alert error"
                                title="Are you sure you want to delete this value?"
                            >
                                <i class="fa fa-times-circle"></i>
                            </a>
                        </td>
                    </tr>
                <?php
                }
                ?>
            </tbody>
        </table>

        <input type="hidden" id="orderbytable" value="properties" />
        <input type="hidden" id="orderbyfield" value="order" />

    </form>
    <?php
    } else {
        ?>
        <p>No values for property "<?= clean_page($property_type_data['name']) ?>"</p>
        <?php
    }

include $path . 'core/admin/templates/pagination.php';

require_once $path . 'core/admin/templates/adminfooter.html.php';
