<?php

use Mtc\Shop\Vat;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$display_form = true;
$errors = [];

init_request_values([
    'id' => null,
]);

$page_meta['title'] = 'Add VAT Rate';

if ($_REQUEST['action'] == 'add') {
    if ($_REQUEST['rate'] == '') {
        $errors['rate'] = 'You must enter a vat amount';
    } else {
        $vat = Vat::query()
            ->create([
                'name' => $_REQUEST['rate'],
            ]);
    }
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li><a href="manage.vat.php">Manage VAT Rates</a> /</li>
        <li class="end"><?= clean_page($page_meta['title']) ?></li>
    </ul>

    <h1>VAT Rate</h1>
<?php

include 'tabnav.php';

if ($display_form) {

    if (sizeof($errors) > 0) {
        showerrors($errors);
    }
    if (sizeof($errors) == 0 && isset($_REQUEST['action'])) {
        echo showmsg("VAT Rate added", "success", $path);
    }
    ?>

    <form action="" method="post" enctype="multipart/form-data" class="style">
        <fieldset class="show">
            <h1><a class="show el">VAT Rate <i class="fa fa-caret-right"></i></a></h1>
            <div class="row">
                <label for="name">Rate (%)</label>
                <input type="text" name="rate" id="rate" value="<?= $data['rate'] ?? null ?>" class="short"/>
            </div>
        </fieldset>
        <fieldset>
            <div class="save-button">
                <input type="hidden" name="action" value="add"/>
                <input type="submit" value="Save"/>
            </div>
        </fieldset>
    </form>
    <?php
} else {
    ?>
    <div>
        VAT rate has been added.
    </div>
    <?php
}
?>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
