<?php

use Mtc\Shop\Order\Protx;

$path = "../../../";
require($path . 'core/includes/header.inc.php');

if ($basket->cost_total > 0) {
    header('Location: /shop/checkout/basket_overview.php?error=nophoneorder');
    exit();
}

if (empty($_SESSION['discounted_order_id']) || $_REQUEST['order_id'] != $_SESSION['discounted_order_id']) {
    $values = [];

    $newbasket = Order::getFromBasketId($_SESSION['basket_id']);
    $values['VendorTxCode'] = ($newbasket->hasNHSItems() ? 'NHS-' : 'COUPON-') . $_REQUEST['order_id'];

    $paymentExists = Protx::query()
        ->where('VendorTxCode', $values['VendorTxCode'])
        ->exists();
    if (!$paymentExists) {

        $values['Amount'] = $basket->cost_total;

        $newbasket->markPaid();
        $newbasket->sendOrderConfirmation();

        if (PPC_TRACKING) {
            track('sale', $newbasket->getTotalCost(), $newbasket->ref, $newbasket->keywords);
        }

        $newbasket = new Order($_REQUEST['order_id']);
        $_SESSION['discounted_order_id'] = $newbasket->getId();
        $_SESSION['basket_id'] = '';

    }
}

if (!empty($_REQUEST['order_id'])) {
    $basket = new Order($_REQUEST['order_id']);
    echo $twig->render('shop/checkout/order_complete.twig', array(
        'page_meta' => $page_meta,
        'basket_object' => $basket,
    ));
} else {
    header('Location: /');
    exit;
}
