<?php

$path = '../../';
require_once $path . 'core/includes/header.inc.php';

use App\ShopHelper;
use Illuminate\Support\Arr;
use MtcPharmacy\Bundles\Classes\Bundle;


$redirect_url = '/shop/checkout/basket.php';

if (request()->input('check_existing_subscriptions')) {

    $basket = Basket::getCurrent();

    foreach ($basket->items as $basket_item) {
        $bundle_id = Arr::get($basket_item, 'bundle_id');
        $bundle = Bundle::find($bundle_id);

        if ($bundle && ShopHelper::hasCustomerSubscriptionToBundleType($bundle->type)) {
            $query_params = [
                'return_url' => '/shop/checkout',
                'bundletype_id' => $bundle->type->id,
            ];

            $redirect_url = route('subscription-create-choice', $query_params, false);
            break;
        }
    }

}

header("Location: {$redirect_url}");
