<?php
require_once SITE_PATH . '/shop/checkout/stripe/stripe.config.php';
?>

<noscript>
    You must <a href="http://www.enable-javascript.com" target="_blank">enable JavaScript</a> in your web browser in order to pay via Stripe.
</noscript>

<form action="/shop/checkout/stripe/order.stripe.php" method="post">
    <input type="hidden" name="order_id" value="<?= $newbasket->order_id ?>" />
    <button type="submit"
        class="checkoutButton"
        id="payWithStripe"
        value=""
        data-key="<?= $stripe_config['publishable_key'] ?>"
        data-amount="<?= round($newbasket->cost_total * 100) ?>"
        data-currency="GBP"
        data-name="<?= clean_page(config('app.name')) ?>"
        data-locale="auto"

        <?php
        //Add site logo to stripe form
        if (defined('STRIPE_LOGO') && STRIPE_LOGO === true) {
            ?>
            data-image="<?= SITE_URL . THEME_PATH ?>/images/logo.png"
            <?php
        }
          //Fill email field
        if (!empty($newbasket->info['email'])) {
            ?>
            data-email="<?= $newbasket->info['email'] ?>"
            <?php
        }
        ?>
    >
        Make payment securely <i class="fa fa-lock"></i>
    </button>

</form>

<?php
if ((defined('STRIPE_MTC_TEST') && STRIPE_MTC_TEST === true) ||
    (defined('STRIPE_LIVE') && STRIPE_LIVE !== true))
    {
    ?>
    <div class="error">This site is currently processing orders through the Stripe MTC gateway!</div>
    <?php
    }
?>
