<?php
/**
 * Basket Item Object Eloquent model.
 * @version 12/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Basket;

use Mtc\Shop\Item\BelongsToItem;
use Illuminate\Database\Eloquent\Model;

/**
 * Basket Item Object Eloquent model.
 * Implements functionality for managing Shop Basket Items
 *
 * @version 12/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Item extends Model
{
    // Use trait that defines relationship to items
    use BelongsToItem;
    // Use trait that defines relationship to basket
    use BelongsToBasket;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'basket_items';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'basket_id',
        'item_id',
        'bundle_id',
        'prescription_item_id',
        'assessment_id',
        'size',
        'quantity',
        'recommended_quantity',
        'PLU',
        'sizeid',
        'nhs_prescription',
        'refill_date',
        'has_requested_subscription',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public function getName()
    {
        return 'test';
    }


    public function shop_item()
    {
        return $this->belongsTo(\Mtc\Shop\Item::class, 'item_id');
    }

    public function shop_item_size()
    {
        return $this->belongsTo(\Mtc\Shop\Item\Size::class, 'sizeid');
    }


    public function prescription_item()
    {
        return $this->belongsTo(\Mtc\Plugins\NHS\Classes\PrescriptionItem::class);
    }


    public function bundle()
    {
        return $this->belongsTo(\MtcPharmacy\Bundles\Classes\Bundle::class);
    }

}
