<?php
namespace Mtc\Shop\Category;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\Shop\Category;

/**
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class ItemComparison extends Model
{
    protected $table = 'category_item_comparison';

    protected $fillable = [
        'category_id',
        'item_name',
        'feature_name',
        'value',
    ];

    /**
     * Define the relationship to categories
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * Create data collection for price comparison
     * Price comparison data grouped by products
     *
     * @param int $category_id category whose data to fetch
     * @return array
     */
    public static function getComparisonTable($category_id) : array
    {
        
        return [];
        
        $category = Category::query()->find($category_id);

        $features = $category->comparison_items()->orderBy('id')->groupBy('feature_name')->pluck('feature_name');
        if (! $features->count()) {
            return [];
        }
        $items = $category->comparison_items()->orderBy('id')->where('feature_name', $features[0])->pluck('item_name');
        $values = $category->comparison_items()->orderBy('id')->get();
        if (count($items) === 0 || count($values) === 0) {
            return [];
        }
        $table = [];
        $table[-1][-1] = '';
        foreach ($items as $item_key => $item) {
            $table[-1][$item_key] = $item;
        }
        foreach ($features as $feature_key => $feature) {
            $table[$feature_key][-1] = $feature;
            foreach ($items as $item_key => $item) {
                foreach ($values as $value) {
                    if ($value->feature_name === $feature && $value->item_name === $item) {
                        $table[$feature_key][$item_key] = $value->value;
                    }
                }
            }
        }
        return $table;
    }

}
