<?php

use App\MultisiteHelper;
use Illuminate\Support\Facades\Cache;
use Mtc\Cms\Models\Page as CmsPage;
use Mtc\Shop\Category;

/*
 * Page objects needed globally
 */
if (defined('CMS_ENABLED') && CMS_ENABLED === true) {
    $homepage_id = ContentManager::getFrontPageId();
    $page = MultisiteHelper::getCmsPageToDisplay($homepage_id);
    $resolved_homepage_id = $page->id ?? $homepage_id;

    $homepage = Cache::remember("cms_page::{$resolved_homepage_id}", 3600 * 12, function () use ($resolved_homepage_id) {
        return new Page($resolved_homepage_id);
    });

    $twig->addGlobal('homepage', $homepage);

    /*
     * Order Cutoff Timer
     */
    if (!empty($homepage->pagedata['Show Delivery Timer'][0]['value'])) {
        $cutoff = $homepage->pagedata['Cutoff Time'][0]['value'] ?? null;
        $order_until = DeliveryMethod::getOrderUntilTime($cutoff);
        $twig->addGlobal('order_until', $order_until);
    }

    /*
     * Cookie notice
    */
    if (isset($homepage->pagedata['Cookie Notice']) &&
        $homepage->pagedata['Cookie Notice'][0]['Enable Cookie Notice']['value'] == '1') {
        $twig->addGlobal('cookie_policy_page', $homepage->pagedata['Cookie Notice'][0]['Cookie Policy Link']['value']);

        if (!empty($_COOKIE['acceptedCookies'])) {
            if ($_COOKIE['acceptedCookies'] != '1') {
                $twig->addGlobal('cookie_notice', true);
            }
        } else {
            $twig->addGlobal('cookie_notice', true);
        }
    }

    /*
     * Contact Page
     */
    $contact_page_id = 12;

    if ($contact_page_id) {
        $contact_page = MultisiteHelper::getCmsPageToDisplay($contact_page_id);
        $contact = Cache::remember("cms_page::{$contact_page->id}", 3600 * 12, function () use ($contact_page) {
            return new Page($contact_page->id);
        });
        $twig->addGlobal('contact', $contact);
    }

    /*
     * Slideshow if present
     */
    if (!empty($p->pagedata['Slideshow'])) {
        $twig->addGlobal('slideshow', $p->pagedata['Slideshow']);
    }

    if (!empty($p->pagedata['Hide Pharmacy Items'][0]['value'])) {
        $twig->addGlobal('hide_pharmacy_items', true);
    }
}

/*
 * Trust Logos
 * Use 'active' to enable/disable logos globally
 * Use 'show_in_banners' to enable logos on banner versions, including hero version
 * Use show_in_breadcrumbs to enable/disable breadcrumb logos
 * Use show_in_footer to enable/disable footer logos
*/
$trust_logos = [
    [
        'active' => false,
        'title' => 'Medicine Registered Seller',
        'url' => $GLOBALS['settings']['MEDICINE_SELLER_REGISTER_URL'] ?? null,
        'img_path' => ($GLOBALS['settings']['THEME_URL'] ?? null) . '/images/icons/eu-common-logo.png',
        'helper_script' => false,
        'link_class' => false,
        'img_class' => 'lazyFade medSellerLogo',
    ],
    [
        'active' => true,
        'title' => 'General Pharmaceutical Council',
        'url' => $GLOBALS['settings']['GENERAL_PHARMACEUTICAL_COUNCIL_URL'] ?? null,
        'img_path' => ($GLOBALS['settings']['THEME_URL'] ?? null) . '/images/icons/reg.png',
        'helper_script' => false,
        'link_class' => false,
        'img_class' => 'lazyFade regLogo',
    ],
    [
        'active' => true,
        'title' => 'NHS',
        'hide_on_footer' => true,
        'url' => 'https://www.nhs.uk/',
        'img_path' => ($GLOBALS['settings']['THEME_URL'] ?? null) . '/images/icons/nhs.png',
        'helper_script' => false,
        'link_class' => false,
        'img_class' => 'lazyFade nhsLogo',
    ],
    [
        'active' => false,
        'title' => 'Trust Pilot',
        'url' => 'https://uk.trustpilot.com/',
        'img_path' => ($GLOBALS['settings']['THEME_URL'] ?? null) . '/images/icons/trust-pilot.svg',
        'helper_script' => false,
        'link_class' => false,
        'img_class' => 'rectangleLogo',
    ],

];

// check for active logos
$trust_logos_active = false;
$trust_scripts = [];
$breadcrumb_logos = [];

foreach ($trust_logos as $logo) {
    if (!empty($logo['active'])) {
        $trust_logos_active = true;

        if (!empty($logo['helper_script'])) {
            $trust_scripts[] = $logo['helper_script'];
        }

        if (!empty($logo['show_in_breadcrumbs'])) {
            $breadcrumb_logos[] = $logo;
        }
    }
}

if (!empty($trust_logos_active)) {
    $twig->addGlobal('trust_logos', $trust_logos);
    $twig->addGlobal('trust_breadcrumb_logos', $breadcrumb_logos);
}

if (!empty($trust_scripts) && !empty($trust_logos_active)) {
    $twig->addGlobal('trust_logo_scripts', $trust_scripts);
}

/*
* Page Links
*/
//$twig->addGlobal('online_doctor_page', $online_doctor_page->url);
$twig->addGlobal('terms_and_conditions', '/customer-care/terms-and-conditions');
$twig->addGlobal('privacy_policy', '/customer-care/privacy-policy');
$twig->addGlobal('delivery_page', '/customer-care/delivery/');

/*
 * NHS Form Content
 */
$nhs_landing_page = Cache::remember("cms_page::72", 3600 * 12, function () {
    return new Page(72);
});
$twig->addGlobal('help_overlay', $nhs_landing_page->pagedata['NHS Prescription Form Help'][0] ?? null);

/*
* Settings
*/
$twig->addGlobal('disable_breadcrumbs', false);

/*
 * Content blocks with sidebar
 */
if (!empty($p->pagedata['Content Sections'])) {
    $description_tabs = [];

    //Loop each content section
    foreach ($p->pagedata['Content Sections'] as $row) {

        //Build array content
        $title = $row['Title']['value'] ?? null;
        $content = $row['Content']['value'] ?? null;

        //Add to tabs is content exists
        if (!empty($title) && !empty($content)) {

            $cta_text = false;
            $cta_link = false;

            if (!empty($row['CTA Button Text']['value'])
                && !empty($row['CTA Button Link']['value'])) {
                $cta_text = $row['CTA Button Text']['value'];
                $cta_link = $row['CTA Button Link']['value'];
            }

            $description_tabs[] = [
                'title' => $title,
                'content' => $content,
                'cta_text' => $cta_text,
                'cta_link' => $cta_link
            ];

        }
    }

    //Set twig variable to use in template
    $twig->addGlobal('description_tabs', $description_tabs);
}

$twig->addGlobal('use_svg_logo', true);
