
# Implementation Plan: Component Registry

**Branch**: `001-component-registry` | **Date**: 2025-01-27 | **Spec**: [spec.md](spec.md)
**Input**: Feature specification from `/home/kieran/projects/pharmacy-starter/specs/001-component-registry/spec.md`

## Execution Flow (/plan command scope)
```
1. Load feature spec from Input path
   → If not found: ERROR "No feature spec at {path}"
2. Fill Technical Context (scan for NEEDS CLARIFICATION)
   → Detect Project Type from context (web=frontend+backend, mobile=app+api)
   → Set Structure Decision based on project type
3. Fill the Constitution Check section based on the content of the constitution document.
4. Evaluate Constitution Check section below
   → If violations exist: Document in Complexity Tracking
   → If no justification possible: ERROR "Simplify approach first"
   → Update Progress Tracking: Initial Constitution Check
5. Execute Phase 0 → research.md
   → If NEEDS CLARIFICATION remain: ERROR "Resolve unknowns"
6. Execute Phase 1 → contracts, data-model.md, quickstart.md, agent-specific template file (e.g., `CLAUDE.md` for Claude Code, `.github/copilot-instructions.md` for GitHub Copilot, `GEMINI.md` for Gemini CLI, `QWEN.md` for Qwen Code or `AGENTS.md` for opencode).
7. Re-evaluate Constitution Check section
   → If new violations: Refactor design, return to Phase 1
   → Update Progress Tracking: Post-Design Constitution Check
8. Plan Phase 2 → Describe task generation approach (DO NOT create tasks.md)
9. STOP - Ready for /tasks command
```

**IMPORTANT**: The /plan command STOPS at step 7. Phases 2-4 are executed by other commands:
- Phase 2: /tasks command creates tasks.md
- Phase 3-4: Implementation execution (manual or via tools)

## Summary
Component Registry to browse and preview all Twig components from sites/default/templates/includes/. Displays components as cards with auto-generated descriptions, supports 50-200 components organized by categories, and provides isolated component viewing with usage instructions. Vue.js component listing page with Twig-based detail pages for component isolation.

## Technical Context
**Language/Version**: PHP 8.4, Vue.js 2, Twig templating
**Primary Dependencies**: Laravel 11, Vite build system (existing), existing Vue.js 2 components
**Storage**: File system scanning (sites/default/templates/includes/), no database required
**Testing**: PHPUnit for PHP components, existing test framework
**Target Platform**: Web application (existing pharmacy system)
**Project Type**: web - frontend Vue.js component + backend Twig templates
**Performance Goals**: <5 seconds page load time for registry main page
**Constraints**: Must preserve existing Vite single JS/CSS file compilation, use existing layout structure
**Scale/Scope**: 50-200 components organized by directory structure, public access (no auth required)

**Additional Implementation Details**:
- Current Vite compiles all assets into one js and one css file - do not change this, just include the full files
- Component listing page as Vue component, detail pages in Twig with new blank layout (no header/footer)
- New layout similar to sites/default/templates/layouts/main.twig but isolated

## Constitution Check
*GATE: Must pass before Phase 0 research. Re-check after Phase 1 design.*

**Healthcare Compliance First**:
- [x] Feature handles patient data appropriately - NO patient data involved (component registry for developers)
- [x] GDPR/MHRA compliance verified - Public developer tool, no sensitive data
- [x] Patient safety impact assessed - No direct patient impact (internal developer tool)

**Modular Plugin Architecture**:
- [x] Changes respect core/, shop/, cms/, plugins/ separation - Uses existing architecture
- [x] New features implemented as plugins where appropriate - Integrates with existing frontend structure
- [x] Cross-module dependencies use proper interfaces - Uses existing Vue.js and Twig systems

**Legacy-Compatible Evolution**:
- [x] Backward compatibility maintained - No changes to existing Vite compilation
- [x] Migration scripts provided for any breaking changes - No breaking changes planned
- [x] Framework upgrade patterns followed - Uses existing Vue.js 2 and Twig patterns

**Multi-Environment Consistency**:
- [x] Works across Docker, server, and local environments - Uses existing file system and web stack
- [x] Environment-agnostic configuration - No special configuration required
- [x] Consistent build outputs - Preserves existing Vite single JS/CSS compilation

**Test-Driven Healthcare Features**:
- [x] PHPUnit tests planned - For PHP component scanning logic
- [x] Integration tests cover workflows - Component discovery and rendering workflows
- [x] Manual testing protocols documented - Component preview and usage validation

## Project Structure

### Documentation (this feature)
```
specs/[###-feature]/
├── plan.md              # This file (/plan command output)
├── research.md          # Phase 0 output (/plan command)
├── data-model.md        # Phase 1 output (/plan command)
├── quickstart.md        # Phase 1 output (/plan command)
├── contracts/           # Phase 1 output (/plan command)
└── tasks.md             # Phase 2 output (/tasks command - NOT created by /plan)
```

### Source Code (repository root)
```
# Option 1: Single project (DEFAULT)
src/
├── models/
├── services/
├── cli/
└── lib/

tests/
├── contract/
├── integration/
└── unit/

# Option 2: Web application (when "frontend" + "backend" detected)
backend/
├── src/
│   ├── models/
│   ├── services/
│   └── api/
└── tests/

frontend/
├── src/
│   ├── components/
│   ├── pages/
│   └── services/
└── tests/

# Option 3: Mobile + API (when "iOS/Android" detected)
api/
└── [same as backend above]

ios/ or android/
└── [platform-specific structure]
```

**Structure Decision**: Option 2 - Web application (existing pharmacy system with frontend/backend separation)

## Phase 0: Outline & Research
1. **Extract unknowns from Technical Context** above:
   - For each NEEDS CLARIFICATION → research task
   - For each dependency → best practices task
   - For each integration → patterns task

2. **Generate and dispatch research agents**:
   ```
   For each unknown in Technical Context:
     Task: "Research {unknown} for {feature context}"
   For each technology choice:
     Task: "Find best practices for {tech} in {domain}"
   ```

3. **Consolidate findings** in `research.md` using format:
   - Decision: [what was chosen]
   - Rationale: [why chosen]
   - Alternatives considered: [what else evaluated]

**Output**: research.md with all technical decisions resolved - NO NEEDS CLARIFICATION items found

## Phase 1: Design & Contracts
*Prerequisites: research.md complete*

1. **Extract entities from feature spec** → `data-model.md`:
   - Entity name, fields, relationships
   - Validation rules from requirements
   - State transitions if applicable

2. **Generate API contracts** from functional requirements:
   - For each user action → endpoint
   - Use standard REST/GraphQL patterns
   - Output OpenAPI/GraphQL schema to `/contracts/`

3. **Generate contract tests** from contracts:
   - One test file per endpoint
   - Assert request/response schemas
   - Tests must fail (no implementation yet)

4. **Extract test scenarios** from user stories:
   - Each story → integration test scenario
   - Quickstart test = story validation steps

5. **Update agent file incrementally** (O(1) operation):
   - Run `.specify/scripts/powershell/update-agent-context.ps1 -AgentType claude`
     **IMPORTANT**: Execute it exactly as specified above. Do not add or remove any arguments.
   - If exists: Add only NEW tech from current plan
   - Preserve manual additions between markers
   - Update recent changes (keep last 3)
   - Keep under 150 lines for token efficiency
   - Output to repository root

**Output**: data-model.md, contracts/component-registry-api.md, quickstart.md (agent file update not required)

## Phase 2: Task Planning Approach
*This section describes what the /tasks command will do - DO NOT execute during /plan*

**Task Generation Strategy**:
- Load `.specify/templates/tasks-template.md` as base
- Generate tasks from Phase 1 design docs (contracts, data model, quickstart)
- API contract → contract test tasks [P] for /api/components endpoints
- Component entity → PHP model/service creation tasks [P]
- Vue.js component → frontend component creation task
- Twig layout → isolated layout creation task
- Integration tests for component discovery and rendering workflows

**Ordering Strategy**:
- TDD order: Tests before implementation
- Dependency order: PHP services → Vue.js components → Twig templates → Routes
- Mark [P] for parallel execution (different files/modules)

**Estimated Output**: 20-25 numbered, ordered tasks in tasks.md

**Key Implementation Areas**:
- PHP component scanning service with caching
- Vue.js component registry listing component
- Twig isolated layout template
- API routes for component data and preview
- Integration with existing Vite build system

**IMPORTANT**: This phase is executed by the /tasks command, NOT by /plan

## Phase 3+: Future Implementation
*These phases are beyond the scope of the /plan command*

**Phase 3**: Task execution (/tasks command creates tasks.md)  
**Phase 4**: Implementation (execute tasks.md following constitutional principles)  
**Phase 5**: Validation (run tests, execute quickstart.md, performance validation)

## Complexity Tracking
*Fill ONLY if Constitution Check has violations that must be justified*

No constitutional violations detected. Implementation follows all established principles:
- Healthcare Compliance: No patient data involved
- Modular Architecture: Integrates with existing Vue.js/Twig systems
- Legacy Compatibility: No changes to existing Vite compilation
- Multi-Environment: Uses existing file system and web stack
- Test-Driven: PHPUnit tests and integration tests planned


## Progress Tracking
*This checklist is updated during execution flow*

**Phase Status**:
- [x] Phase 0: Research complete (/plan command)
- [x] Phase 1: Design complete (/plan command)
- [x] Phase 2: Task planning complete (/plan command - describe approach only)
- [ ] Phase 3: Tasks generated (/tasks command)
- [ ] Phase 4: Implementation complete
- [ ] Phase 5: Validation passed

**Gate Status**:
- [x] Initial Constitution Check: PASS
- [x] Post-Design Constitution Check: PASS
- [x] All NEEDS CLARIFICATION resolved
- [x] Complexity deviations documented (none required)

---
*Based on Constitution v1.0.0 - See `.specify/memory/constitution.md`*
