<?php

namespace Mtc\VehicleLookup\Config;

use Mtc\VehicleValuation\Config\AutoTraderConfig as ValuationAutoTraderConfig;

class AutoTraderConfig extends ValuationAutoTraderConfig
{
    public function enabled(): bool
    {
        return !empty($this->apiKey()) && !empty($this->apiSecret());
    }

    public function apiKey(): string
    {
        return config('lookup.drivers.auto-trader.api_key');
    }

    public function apiSecret(): string
    {
        return config('lookup.drivers.auto-trader.api_secret');
    }

    public function merchantId(): string
    {
        return config('lookup.drivers.auto-trader.merchant_id');
    }

    public function live(): bool
    {
        return config('lookup.drivers.auto-trader.live');
    }
}
