<?php

namespace Mtc\VehicleLookup\Contracts;

use App\Modules\Lookup\Contracts\VehicleLookupData;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\VehicleLookup\VehicleLookupResponse;

interface VehicleLookupDriver
{
    public function lookup(string $registration_number, int $mileage): VehicleLookupResponse;
    public function findDerivatives(VehicleMake $make, VehicleModel $model): array;
    public function findVariants(VehicleMake $make, VehicleModel $model, string $derivative = ''): array;
    public function getTechnicalData(string $variant): VehicleLookupData;
}
