<?php

namespace Mtc\VehicleValuation\Models;

use Illuminate\Database\Eloquent\Model;
use Mtc\ContentManager\Traits\ModelSortAndFilter;

class VehicleValuation extends Model
{
    use ModelSortAndFilter;

    protected $table = 'valuations';

    protected $fillable = [
        'user_id',
        'provider',
        'registration',
        'mileage',
        'vehicle_type',
        'make',
        'model',
        'derivative',
        'fuel_type',
        'engine_size',
        'body_type',
        'transmission',
        'date_of_registration',
        'valuation_made_at',
        'retail_price',
        'average_price',
        'clean_price',
        'below_price',
        'colour',
        'errors',
        'valuation_id',
        'data',
        'cosmetic_condition',
    ];

    protected $casts = [
        'errors' => 'array',
        'data' => 'array',
        'valuation_made_at' => 'datetime',
    ];
}
