<?php

namespace Mtc\VehicleValuation\Config;

use GuzzleHttp\Client;

class CapConfig
{
    public function __construct(public Client $client)
    {
    }

    public function enabled(): bool
    {
        return !empty($this->subscriberId()) && !empty($this->password());
    }

    public function subscriberId(): string
    {
        return config('valuation.drivers.cap.subscriber_id');
    }

    public function password(): string
    {
        return config('valuation.drivers.cap.password');
    }
}
